/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingType;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.utils.CommonUtils;

public class ComplexTypeAttributeTransformer
implements DBDAttributeTransformer {
    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, String> options) throws DBException {
        if (!session.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.transform.complex.type")) {
            return;
        }
        DBSDataType dataType = attribute.getAttribute() instanceof DBSTypedObjectEx ? ((DBSTypedObjectEx)((Object)attribute.getAttribute())).getDataType() : DBUtils.resolveDataType(session.getProgressMonitor(), session.getDataSource(), attribute.getTypeName());
        if (dataType instanceof DBSEntity) {
            ComplexTypeAttributeTransformer.createNestedTypeBindings(session, attribute, rows, (DBSEntity)((Object)dataType));
        }
    }

    static void createNestedTypeBindings(DBCSession session, DBDAttributeBinding attribute, List<Object[]> rows, DBSEntity dataType) throws DBException {
        ArrayList<DBDAttributeBinding> nestedBindings = new ArrayList<DBDAttributeBinding>();
        for (DBSEntityAttribute nestedAttr : CommonUtils.safeCollection(dataType.getAttributes(session.getProgressMonitor()))) {
            DBDAttributeBindingType nestedBinding = new DBDAttributeBindingType(attribute, nestedAttr);
            nestedBinding.lateBinding(session, rows);
            nestedBindings.add(nestedBinding);
        }
        if (!nestedBindings.isEmpty()) {
            attribute.setNestedBindings(nestedBindings);
        }
    }
}

