/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.control;

import java.util.Date;
import java.util.List;
import org.apache.commons.jexl2.Expression;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardChartComposite;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardList;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardRenderer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardCalcType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardDataType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardFetchType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardGroupContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardInterval;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardMapQuery;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardQuery;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardValueType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewType;
import org.jkiss.dbeaver.ui.dashboard.model.data.DashboardDataset;

public class DashboardItem
extends Composite
implements DashboardContainer {
    public static final int DEFAULT_HEIGHT = 200;
    private DashboardList groupContainer;
    private final DashboardItemViewConfiguration dashboardConfig;
    private Date lastUpdateTime;
    private DashboardViewType curViewType;
    private DashboardRenderer renderer;
    private DashboardChartComposite dashboardControl;
    private final Label titleLabel;
    private final Composite chartComposite;

    public DashboardItem(DashboardList parent, String dashboardId) {
        super((Composite)parent, 0x20000000);
        this.setLayoutData(new GridData(1808));
        this.groupContainer = parent;
        this.dashboardConfig = this.groupContainer.getView().getViewConfiguration().getDashboardConfig(dashboardId);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.setLayout((Layout)layout);
        Color defFG = UIStyles.getDefaultTextForeground();
        Color defBG = UIStyles.getDefaultTextBackground();
        this.setBackground(defBG);
        Composite titleComposite = new Composite((Composite)this, 0);
        titleComposite.setLayoutData((Object)new GridData(768));
        titleComposite.setBackground(defBG);
        titleComposite.setForeground(defFG);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 3;
        fillLayout.marginWidth = 3;
        titleComposite.setLayout((Layout)fillLayout);
        this.titleLabel = new Label(titleComposite, 0);
        this.titleLabel.setFont(parent.getTitleFont());
        this.titleLabel.setText("  " + this.dashboardConfig.getDashboardDescriptor().getName());
        this.chartComposite = new Composite((Composite)this, 0);
        this.chartComposite.setLayoutData((Object)new GridData(1808));
        this.chartComposite.setLayout((Layout)new FillLayout());
        this.createChartRenderer();
        this.groupContainer.addItem(this);
        this.addDisposeListener(e -> this.groupContainer.removeItem(this));
        this.addPaintListener(this::paintItem);
    }

    private void createChartRenderer() {
        try {
            this.curViewType = this.dashboardConfig.getViewType();
            this.renderer = this.curViewType.createRenderer();
            this.dashboardControl = this.renderer.createDashboard(this.chartComposite, this, this.groupContainer.getView(), this.computeSize(-1, -1));
        }
        catch (DBException e2) {
            Text errorLabel = new Text((Composite)this, 74);
            errorLabel.setText("Error creating " + this.dashboardConfig.getDashboardDescriptor().getName() + " renderer: " + e2.getMessage());
            errorLabel.setLayoutData((Object)new GridData(2, 2, true, true));
        }
        if (this.dashboardControl != null) {
            final Canvas chartCanvas = this.dashboardControl.getChartCanvas();
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    chartCanvas.setFocus();
                }
            };
            this.addMouseListener((MouseListener)mouseAdapter);
            chartCanvas.addMouseListener((MouseListener)mouseAdapter);
            this.titleLabel.addMouseListener((MouseListener)mouseAdapter);
            chartCanvas.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    DashboardItem.this.groupContainer.setSelection(DashboardItem.this);
                    DashboardItem.this.redraw();
                }

                public void focusLost(FocusEvent e) {
                }
            });
            chartCanvas.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    DashboardItem.this.groupContainer.handleKeyEvent(e);
                }
            });
            this.dashboardControl.addDisposeListener(e -> this.renderer.disposeDashboard(this));
        }
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    private void paintItem(PaintEvent e) {
        Point itemSize = this.getSize();
        e.gc.setForeground(this.getDisplay().getSystemColor(17));
        if (this.groupContainer.getSelectedItem() == this) {
            e.gc.setLineWidth(2);
            e.gc.setLineStyle(1);
        } else {
            e.gc.setLineWidth(1);
            e.gc.setLineStyle(1);
        }
        e.gc.drawRectangle(1, 1, itemSize.x - 2, itemSize.y - 2);
    }

    public int getDefaultHeight() {
        return 200;
    }

    public int getDefaultWidth() {
        return (int)(this.dashboardConfig.getWidthRatio() * (float)this.getDefaultHeight());
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point listAreaSize = this.groupContainer.getSize();
        if (this.groupContainer.getView().isSingleChartMode() || listAreaSize.x <= 0 || listAreaSize.y <= 0) {
            return super.computeSize(wHint, hHint, changed);
        }
        GridLayout listLayout = (GridLayout)this.groupContainer.getLayout();
        int listRowCount = this.groupContainer.getListRowCount();
        int listColumnCount = this.groupContainer.getListColumnCount();
        int width = (listAreaSize.x - listLayout.marginWidth * 2 - listLayout.horizontalSpacing * (listColumnCount - 1)) / listColumnCount;
        int height = (listAreaSize.y - listLayout.marginHeight * 2 - listLayout.verticalSpacing * (listRowCount - 1)) / listRowCount;
        return new Point(width, height);
    }

    public DashboardItemViewConfiguration getDashboardConfig() {
        return this.dashboardConfig;
    }

    @Override
    public String getDashboardId() {
        return this.dashboardConfig.getDashboardDescriptor().getId();
    }

    @Override
    public String getDashboardTitle() {
        return this.dashboardConfig.getDashboardDescriptor().getName();
    }

    @Override
    public String getDashboardDescription() {
        return this.dashboardConfig.getDescription();
    }

    @Override
    public DashboardViewType getDashboardViewType() {
        return this.dashboardConfig.getViewType();
    }

    @Override
    public DashboardDataType getDashboardDataType() {
        return this.dashboardConfig.getDashboardDescriptor().getDataType();
    }

    @Override
    public DashboardCalcType getDashboardCalcType() {
        return this.dashboardConfig.getDashboardDescriptor().getCalcType();
    }

    @Override
    public DashboardValueType getDashboardValueType() {
        return this.dashboardConfig.getDashboardDescriptor().getValueType();
    }

    @Override
    public DashboardInterval getDashboardInterval() {
        return this.dashboardConfig.getDashboardDescriptor().getInterval();
    }

    @Override
    public DashboardFetchType getDashboardFetchType() {
        return this.dashboardConfig.getDashboardDescriptor().getFetchType();
    }

    @Override
    public int getDashboardMaxItems() {
        return this.dashboardConfig.getMaxItems();
    }

    @Override
    public long getDashboardMaxAge() {
        return this.dashboardConfig.getMaxAge();
    }

    @Override
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.groupContainer.getDataSourceContainer();
    }

    @Override
    public DashboardGroupContainer getGroup() {
        return this.groupContainer;
    }

    @Override
    public DashboardMapQuery getMapQuery() {
        return this.dashboardConfig.getDashboardDescriptor().getMapQuery();
    }

    @Override
    public String[] getMapKeys() {
        return this.dashboardConfig.getDashboardDescriptor().getMapKeys();
    }

    @Override
    public String[] getMapLabels() {
        return this.dashboardConfig.getDashboardDescriptor().getMapLabels();
    }

    @Override
    public Expression getMapFormula() {
        return this.dashboardConfig.getDashboardDescriptor().getMapFormulaExpr();
    }

    @Override
    public List<? extends DashboardQuery> getQueryList() {
        return this.dashboardConfig.getDashboardDescriptor().getQueries();
    }

    @Override
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void updateDashboardData(DashboardDataset dataset) {
        UIUtils.asyncExec(() -> {
            if (this.renderer != null) {
                this.renderer.updateDashboardData(this, this.lastUpdateTime, dataset);
                this.lastUpdateTime = new Date();
            }
        });
    }

    @Override
    public void resetDashboardData() {
        UIUtils.asyncExec(() -> {
            if (this.renderer != null) {
                this.renderer.resetDashboardData(this, this.lastUpdateTime);
            }
        });
    }

    @Override
    public void updateDashboardView() {
        UIUtils.asyncExec(() -> {
            boolean forceLayout = false;
            if (this.dashboardConfig.getViewType() != this.curViewType) {
                if (this.dashboardControl != null) {
                    this.dashboardControl.dispose();
                    forceLayout = true;
                }
                this.createChartRenderer();
            } else if (this.renderer != null) {
                this.renderer.updateDashboardView(this);
            }
            if (forceLayout) {
                this.chartComposite.layout(true, true);
            }
        });
    }

    @Override
    public long getUpdatePeriod() {
        return this.dashboardConfig.getUpdatePeriod();
    }

    public DashboardChartComposite getDashboardControl() {
        return this.dashboardControl;
    }

    public void moveViewFrom(DashboardItem item, boolean clearOriginal) {
        this.renderer.moveDashboardView(this, item, clearOriginal);
    }
}

