/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPOrderedObject;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEObjectReorderer;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.registry.ObjectManagerRegistry;
import org.jkiss.dbeaver.tools.registry.ToolsRegistry;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.dnd.TreeNodeTransfer;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectCreateNew;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class ObjectPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.object";
    public static final String PROP_CAN_OPEN = "canOpen";
    public static final String PROP_CAN_CREATE_SINGLE = "canCreateSingle";
    public static final String PROP_CAN_CREATE_MULTI = "canCreateMulti";
    public static final String PROP_CAN_PASTE = "canPaste";
    public static final String PROP_CAN_DELETE = "canDelete";
    public static final String PROP_CAN_RENAME = "canRename";
    public static final String PROP_CAN_MOVE_UP = "canMoveUp";
    public static final String PROP_CAN_MOVE_DOWN = "canMoveDown";
    public static final String PROP_CAN_FILTER = "canFilter";
    public static final String PROP_CAN_FILTER_OBJECT = "canFilterObject";
    public static final String PROP_HAS_FILTER = "hasFilter";
    public static final String PROP_HAS_TOOLS = "hasTools";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof DBNNode)) {
            return false;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            return false;
        }
        DBNNode node = (DBNNode)receiver;
        switch (property) {
            case "canOpen": {
                return node.isPersisted();
            }
            case "canCreateSingle": {
                return ObjectPropertyTester.canCreateObject(node, true);
            }
            case "canCreateMulti": {
                return ObjectPropertyTester.canCreateObject(node, false);
            }
            case "canPaste": {
                Clipboard clipboard = new Clipboard(display);
                try {
                    if (clipboard.getContents((Transfer)TreeNodeTransfer.getInstance()) == null) {
                        return false;
                    }
                }
                finally {
                    clipboard.dispose();
                }
                if (node instanceof DBNResource) {
                    return property.equals(PROP_CAN_PASTE);
                }
                return ObjectPropertyTester.canCreateObject(node, null);
            }
            case "canDelete": {
                if (node instanceof DBNDataSource || node instanceof DBNLocalFolder) {
                    return true;
                }
                if (node instanceof DBSWrapper) {
                    DBSObject object = ((DBSWrapper)node).getObject();
                    if (object == null || ObjectPropertyTester.isReadOnly(object) || !(node.getParentNode() instanceof DBNContainer)) {
                        return false;
                    }
                    DBEObjectMaker objectMaker = ObjectPropertyTester.getObjectManager(object.getClass(), DBEObjectMaker.class);
                    return objectMaker != null && objectMaker.canDeleteObject(object);
                }
                if (!(node instanceof DBNResource) || (((DBNResource)node).getFeatures() & 2) == 0) break;
                return true;
            }
            case "canRename": {
                if (node.supportsRename()) {
                    return true;
                }
                if (!(node instanceof DBNDatabaseNode)) break;
                DBSObject object = ((DBNDatabaseNode)node).getObject();
                return object != null && !ObjectPropertyTester.isReadOnly(object) && object.isPersisted() && node.getParentNode() instanceof DBNContainer && ObjectPropertyTester.getObjectManager(object.getClass(), DBEObjectRenamer.class) != null;
            }
            case "canMoveDown": 
            case "canMoveUp": {
                DBEObjectReorderer objectReorderer;
                DBSObject object;
                if (!(node instanceof DBNDatabaseNode) || !((object = ((DBNDatabaseNode)node).getObject()) instanceof DBPOrderedObject) || (objectReorderer = ObjectPropertyTester.getObjectManager(object.getClass(), DBEObjectReorderer.class)) == null) break;
                int position = ((DBPOrderedObject)object).getOrdinalPosition();
                if (property.equals(PROP_CAN_MOVE_UP)) {
                    return position > objectReorderer.getMinimumOrdinalPosition(object);
                }
                return position < objectReorderer.getMaximumOrdinalPosition(object);
            }
            case "canFilter": {
                if (node instanceof DBNDatabaseItem) {
                    node = node.getParentNode();
                }
                if (!(node instanceof DBNDatabaseFolder) || ((DBNDatabaseFolder)node).getItemsMeta() == null) break;
                return true;
            }
            case "canFilterObject": {
                if (!(node.getParentNode() instanceof DBNDatabaseFolder) || ((DBNDatabaseFolder)node.getParentNode()).getItemsMeta() == null) break;
                return true;
            }
            case "hasFilter": {
                if (node instanceof DBNDatabaseItem) {
                    node = node.getParentNode();
                }
                if (!(node instanceof DBNDatabaseFolder) || ((DBNDatabaseFolder)node).getItemsMeta() == null) break;
                DBSObjectFilter filter = ((DBNDatabaseFolder)node).getNodeFilter(((DBNDatabaseFolder)node).getItemsMeta(), true);
                if ("defined".equals(expectedValue)) {
                    return filter != null && !filter.isEmpty();
                }
                return filter != null && !filter.isNotApplicable();
            }
            case "hasTools": {
                IStructuredSelection structuredSelection = NavigatorUtils.getSelectionFromPart((IWorkbenchPart)receiver);
                if (structuredSelection == null || structuredSelection.isEmpty()) {
                    return false;
                }
                DBSObject object = (DBSObject)RuntimeUtils.getObjectAdapter((Object)structuredSelection.getFirstElement(), DBSObject.class);
                return object != null && !CommonUtils.isEmpty(ToolsRegistry.getInstance().getTools(structuredSelection));
            }
        }
        return false;
    }

    public static boolean canCreateObject(DBNNode node, Boolean onlySingle) {
        if (onlySingle == null) {
            if (node instanceof DBNDataSource) {
                return true;
            }
            if (!(node instanceof DBNContainer) && node.getParentNode() instanceof DBNContainer) {
                node = node.getParentNode();
            }
            if (!(node instanceof DBNContainer)) {
                return false;
            }
            Class objectType = ((DBNContainer)node).getChildrenClass();
            DBNContainer container = (DBNContainer)node;
            if (node instanceof DBSWrapper && ObjectPropertyTester.isReadOnly(((DBSWrapper)node).getObject())) {
                return false;
            }
            if (objectType == null) {
                return false;
            }
            DBEObjectMaker objectMaker = ObjectPropertyTester.getObjectManager(objectType, DBEObjectMaker.class);
            if (objectMaker == null) {
                return false;
            }
            return objectMaker.canCreateObject(container.getValueObject());
        }
        List<IContributionItem> createItems = NavigatorHandlerObjectCreateNew.fillCreateMenuItems(null, node);
        if (onlySingle.booleanValue()) {
            return createItems.size() == 1;
        }
        return createItems.size() > 1;
    }

    public static boolean isReadOnly(DBSObject object) {
        if (object == null) {
            return true;
        }
        DBPDataSource dataSource = object.getDataSource();
        return dataSource == null || dataSource.getContainer().isConnectionReadOnly();
    }

    private static <T extends DBEObjectManager> T getObjectManager(Class<?> objectType, Class<T> managerType) {
        return (T)((DBEObjectManager)ObjectManagerRegistry.getInstance().getObjectManager(objectType, managerType));
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.object." + propName));
    }
}

