/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.configurators;

import org.jkiss.dbeaver.ext.oracle.OracleMessages;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraintColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKeyColumn;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;

public class OracleForeignKeyConfigurator
implements DBEObjectConfigurator<OracleTableForeignKey> {
    public OracleTableForeignKey configureObject(DBRProgressMonitor monitor, Object table, final OracleTableForeignKey foreignKey) {
        return (OracleTableForeignKey)new UITask<OracleTableForeignKey>(){

            protected OracleTableForeignKey runTask() {
                EditForeignKeyPage editPage = new EditForeignKeyPage(OracleMessages.edit_oracle_foreign_key_manager_dialog_title, (DBSEntityAssociation)foreignKey, new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.CASCADE, DBSForeignKeyModifyRule.RESTRICT, DBSForeignKeyModifyRule.SET_NULL, DBSForeignKeyModifyRule.SET_DEFAULT});
                editPage.setSupportsCustomName(true);
                if (!editPage.edit()) {
                    return null;
                }
                foreignKey.setReferencedConstraint((OracleTableConstraint)editPage.getUniqueConstraint());
                foreignKey.setName(editPage.getName());
                foreignKey.setDeleteRule(editPage.getOnDeleteRule());
                int colIndex = 1;
                for (EditForeignKeyPage.FKColumnInfo tableColumn : editPage.getColumns()) {
                    foreignKey.addColumn((OracleTableConstraintColumn)new OracleTableForeignKeyColumn(foreignKey, (OracleTableColumn)tableColumn.getOwnColumn(), colIndex++));
                }
                return foreignKey;
            }
        }.execute();
    }
}

