/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.views;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCharset;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCollation;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class MySQLCreateDatabaseDialog
extends BaseDialog {
    public static final String DEFAULT_CHARSET_NAME = "utf8";
    private final MySQLCatalog database;
    private String name;
    private MySQLCharset charset;
    private MySQLCollation collation;

    public MySQLCreateDatabaseDialog(Shell parentShell, MySQLCatalog database) {
        super(parentShell, "Create database", null);
        this.database = database;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        final Text nameText = UIUtils.createLabelText((Composite)group, (String)"Database name", (String)"");
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MySQLCreateDatabaseDialog.this.name = nameText.getText();
                MySQLCreateDatabaseDialog.this.getButton(0).setEnabled(!MySQLCreateDatabaseDialog.this.name.isEmpty());
            }
        });
        Combo charsetCombo = UIUtils.createLabelCombo((Composite)group, (String)"Charset", (int)2052);
        for (MySQLCharset cs : this.database.getDataSource().getCharsets()) {
            charsetCombo.add(cs.getName());
        }
        this.charset = this.database.getDataSource().getDefaultCharset();
        if (this.charset == null) {
            this.charset = this.database.getDataSource().getCharset(DEFAULT_CHARSET_NAME);
        }
        this.collation = this.database.getDataSource().getDefaultCollation();
        if (this.collation == null) {
            this.collation = this.charset.getDefaultCollation();
        }
        charsetCombo.setText(this.charset.getName());
        Combo collationCombo = UIUtils.createLabelCombo((Composite)group, (String)"Collation", (int)2052);
        for (MySQLCollation col : this.charset.getCollations()) {
            collationCombo.add(col.getName());
        }
        if (this.collation != null) {
            UIUtils.setComboSelection((Combo)collationCombo, (String)this.collation.getName());
        }
        charsetCombo.addModifyListener(e -> {
            this.charset = this.database.getDataSource().getCharset(charsetCombo.getText());
            assert (this.charset != null);
            collationCombo.removeAll();
            for (MySQLCollation col : this.charset.getCollations()) {
                collationCombo.add(col.getName());
            }
            this.collation = this.charset.getDefaultCollation();
            if (this.collation != null) {
                UIUtils.setComboSelection((Combo)collationCombo, (String)this.collation.getName());
            }
        });
        collationCombo.addModifyListener(e -> {
            MySQLCollation mySQLCollation = this.collation = this.charset.getCollation(collationCombo.getText());
        });
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public MySQLCharset getCharset() {
        return this.charset;
    }

    public MySQLCollation getCollation() {
        return this.collation;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

