"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const util_1 = require("./util");
const { TouchBarButton } = electron_1.TouchBar;
electron_1.ipcMain.on('conversations', (_event, conversations) => {
    const items = conversations.map(({ label, selected, icon }, index) => {
        return new TouchBarButton({
            label: label.length > 25 ? label.slice(0, 25) + '…' : label,
            backgroundColor: selected ? '#0084ff' : undefined,
            icon: electron_1.nativeImage.createFromDataURL(icon),
            iconPosition: 'left',
            click: () => {
                util_1.sendAction('jump-to-conversation', index + 1);
            }
        });
    });
    const touchBar = new electron_1.TouchBar({ items });
    const win = util_1.getWindow();
    win.setTouchBar(touchBar);
});
//# sourceMappingURL=touch-bar.js.map