"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _electron = require("electron");

var _helpers = require("../helpers");

var _source = require("../models/conflicts/source");

var _decoration = _interopRequireDefault(require("../atom/decoration"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const {
  Menu,
  MenuItem
} = _electron.remote;

class ConflictController extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'showResolveMenu');
    this.state = {
      chosenSide: this.props.conflict.getChosenSide()
    };
  }

  resolveAsSequence(sources) {
    this.props.resolveAsSequence(sources);
    this.setState({
      chosenSide: this.props.conflict.getChosenSide()
    });
  }

  revert(side) {
    side.isModified() && side.revert();
    side.isBannerModified() && side.revertBanner();
  }

  showResolveMenu(event) {
    event.preventDefault();
    const menu = new Menu();
    menu.append(new MenuItem({
      label: 'Resolve as Ours',
      click: this.resolveAsSequence.bind(this, [_source.OURS])
    }));

    if (this.props.conflict.getSide(_source.BASE)) {
      menu.append(new MenuItem({
        label: 'Resolve as Base',
        click: this.resolveAsSequence.bind(this, [_source.BASE])
      }));
    }

    menu.append(new MenuItem({
      label: 'Resolve as Theirs',
      click: this.resolveAsSequence.bind(this, [_source.THEIRS])
    }));
    menu.append(new MenuItem({
      type: 'separator'
    }));
    menu.append(new MenuItem({
      label: 'Resolve as Ours Then Theirs',
      click: this.resolveAsSequence.bind(this, [_source.OURS, _source.THEIRS])
    }));
    menu.append(new MenuItem({
      label: 'Resolve as Theirs Then Ours',
      click: this.resolveAsSequence.bind(this, [_source.THEIRS, _source.OURS])
    }));
    menu.append(new MenuItem({
      type: 'separator'
    }));
    menu.append(new MenuItem({
      label: 'Dismiss',
      click: this.props.dismiss
    }));
    menu.popup(_electron.remote.getCurrentWindow());
  }

  render() {
    if (!this.state.chosenSide) {
      const ours = this.props.conflict.getSide(_source.OURS);
      const base = this.props.conflict.getSide(_source.BASE);
      const theirs = this.props.conflict.getSide(_source.THEIRS);
      return _react["default"].createElement("div", null, this.renderSide(ours), base && this.renderSide(base), _react["default"].createElement(_decoration["default"], {
        key: this.props.conflict.getSeparator().getMarker().id,
        editor: this.props.editor,
        decorable: this.props.conflict.getSeparator().getMarker(),
        type: "line",
        className: "github-ConflictSeparator"
      }), this.renderSide(theirs));
    } else if (!this.state.chosenSide.isEmpty()) {
      return _react["default"].createElement(_decoration["default"], {
        editor: this.props.editor,
        decorable: this.state.chosenSide.getMarker(),
        type: "line",
        className: "github-ResolvedLines"
      });
    } else {
      return null;
    }
  }

  renderSide(side) {
    const source = side.getSource();
    return _react["default"].createElement("div", null, _react["default"].createElement(_decoration["default"], {
      key: side.banner.marker.id,
      editor: this.props.editor,
      decorable: side.getBannerMarker(),
      type: "line",
      className: side.getBannerCSSClass()
    }), side.isBannerModified() || _react["default"].createElement(_decoration["default"], {
      key: 'banner-modified-' + side.banner.marker.id,
      editor: this.props.editor,
      decorable: side.getBannerMarker(),
      type: "line",
      className: "github-ConflictUnmodifiedBanner"
    }), _react["default"].createElement(_decoration["default"], {
      key: side.marker.id,
      editor: this.props.editor,
      decorable: side.getMarker(),
      type: "line",
      className: side.getLineCSSClass()
    }), _react["default"].createElement(_decoration["default"], {
      key: 'block-' + side.marker.id,
      editor: this.props.editor,
      decorable: side.getBlockMarker(),
      type: "block",
      position: side.getBlockPosition()
    }, _react["default"].createElement("div", {
      className: side.getBlockCSSClasses()
    }, _react["default"].createElement("span", {
      className: "github-ResolutionControls"
    }, _react["default"].createElement("button", {
      className: "btn btn-sm inline-block",
      onClick: () => this.resolveAsSequence([source])
    }, "Use me"), (side.isModified() || side.isBannerModified()) && _react["default"].createElement("button", {
      className: "btn btn-sm inline-block",
      onClick: () => this.revert(side)
    }, "Revert"), _react["default"].createElement(_octicon["default"], {
      icon: "ellipses",
      className: "inline-block",
      onClick: this.showResolveMenu
    })), _react["default"].createElement("span", {
      className: "github-SideDescription"
    }, source.toUIString()))));
  }

}

exports["default"] = ConflictController;

_defineProperty(ConflictController, "propTypes", {
  editor: _propTypes["default"].object.isRequired,
  conflict: _propTypes["default"].object.isRequired,
  resolveAsSequence: _propTypes["default"].func,
  dismiss: _propTypes["default"].func
});

_defineProperty(ConflictController, "defaultProps", {
  resolveAsSequence: sources => {},
  dismiss: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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