"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Command = exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Commands extends _react["default"].Component {
  render() {
    const {
      registry,
      target
    } = this.props;
    return _react["default"].createElement("div", null, _react["default"].Children.map(this.props.children, child => {
      return child ? _react["default"].cloneElement(child, {
        registry,
        target
      }) : null;
    }));
  }

}

exports["default"] = Commands;

_defineProperty(Commands, "propTypes", {
  registry: _propTypes["default"].object.isRequired,
  target: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes2.DOMNodePropType, _propTypes2.RefHolderPropType]).isRequired,
  children: _propTypes["default"].oneOfType([_propTypes["default"].element, _propTypes["default"].arrayOf(_propTypes["default"].element)]).isRequired
});

class Command extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    this.subTarget = new _eventKit.Disposable();
    this.subCommand = new _eventKit.Disposable();
  }

  componentDidMount() {
    this.observeTarget(this.props);
  }

  componentWillReceiveProps(newProps) {
    if (['registry', 'target', 'command', 'callback'].some(p => newProps[p] !== this.props[p])) {
      this.observeTarget(newProps);
    }
  }

  componentWillUnmount() {
    this.subTarget.dispose();
    this.subCommand.dispose();
  }

  observeTarget(props) {
    this.subTarget.dispose();
    this.subTarget = _refHolder["default"].on(props.target).observe(t => this.registerCommand(t, props));
  }

  registerCommand(target, {
    registry,
    command,
    callback
  }) {
    this.subCommand.dispose();
    this.subCommand = registry.add(target, command, callback);
  }

  render() {
    return null;
  }

}

exports.Command = Command;

_defineProperty(Command, "propTypes", {
  registry: _propTypes["default"].object,
  target: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes2.DOMNodePropType, _propTypes2.RefHolderPropType]),
  command: _propTypes["default"].string.isRequired,
  callback: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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