/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;

final class FieldTableCellRenderer
extends EnhancedTableCellRenderer {
    private final JLabel label1;
    private final JLabel label2;

    public FieldTableCellRenderer() {
        this.setHorizontalAlignment(11);
        this.label1 = new JLabel("");
        this.label2 = new JLabel("");
        this.setLayout(null);
        this.add(this.label1);
        this.add(this.label2);
        this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.label1.getPreferredSize();
        Dimension dimension2 = this.label2.getPreferredSize();
        dimension.width += dimension2.width;
        dimension.height = Math.max(dimension.height, dimension2.height);
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        Dimension dimension = this.label1.getPreferredSize();
        Dimension dimension2 = this.label2.getPreferredSize();
        if (dimension.width >= n) {
            this.label1.setBounds(insets.left, insets.top, n, n2);
            this.label2.setBounds(0, 0, 0, 0);
        } else if (dimension.width + dimension2.width <= n) {
            this.label1.setBounds(this.getWidth() - insets.right - dimension.width - dimension2.width, insets.top, dimension.width, n2);
            this.label2.setBounds(this.getWidth() - insets.right - dimension2.width, insets.top, dimension2.width, n2);
        } else {
            this.label1.setBounds(insets.left, insets.top, dimension.width, n2);
            this.label2.setBounds(insets.left + dimension.width, insets.top, n - dimension.width, n2);
        }
    }

    public Component getTableCellRendererComponentPersistent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return new FieldTableCellRenderer().getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    protected void setRowForeground(Color color) {
        super.setRowForeground(color);
        this.label1.setForeground(color);
        this.label2.setForeground(UIUtils.getDisabledForeground((Color)color));
    }

    protected void setValue(JTable jTable, Object object, int n, int n2) {
        if (object instanceof HeapWalkerNode) {
            HeapWalkerNode heapWalkerNode = (HeapWalkerNode)((Object)object);
            this.label1.setText(heapWalkerNode.getValue());
            String string = heapWalkerNode.getDetails();
            this.label2.setText(string == null || string.isEmpty() ? "" : "  " + string);
        } else {
            this.label1.setText("");
            this.label2.setText("");
        }
    }
}

