/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jrtfs;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import jdk.internal.jrtfs.JrtFileAttributes;
import jdk.internal.jrtfs.JrtPath;

final class JrtFileAttributeView
implements BasicFileAttributeView {
    private final JrtPath path;
    private final boolean isJrtView;
    private final LinkOption[] options;

    private JrtFileAttributeView(JrtPath path, boolean isJrtView, LinkOption ... options) {
        this.path = path;
        this.isJrtView = isJrtView;
        this.options = options;
    }

    static <V extends FileAttributeView> V get(JrtPath path, Class<V> type, LinkOption ... options) {
        Objects.requireNonNull(type);
        if (type == BasicFileAttributeView.class) {
            return (V)new JrtFileAttributeView(path, false, options);
        }
        if (type == JrtFileAttributeView.class) {
            return (V)new JrtFileAttributeView(path, true, options);
        }
        return null;
    }

    static JrtFileAttributeView get(JrtPath path, String type, LinkOption ... options) {
        Objects.requireNonNull(type);
        if (type.equals("basic")) {
            return new JrtFileAttributeView(path, false, options);
        }
        if (type.equals("jrt")) {
            return new JrtFileAttributeView(path, true, options);
        }
        return null;
    }

    @Override
    public String name() {
        return this.isJrtView ? "jrt" : "basic";
    }

    @Override
    public JrtFileAttributes readAttributes() throws IOException {
        return this.path.getAttributes(this.options);
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        this.path.setTimes(lastModifiedTime, lastAccessTime, createTime);
    }

    static void setAttribute(JrtPath path, String attribute, Object value) throws IOException {
        int colonPos = attribute.indexOf(58);
        if (colonPos != -1) {
            String type;
            if (!(type = attribute.substring(0, colonPos++)).equals("basic") && !type.equals("jrt")) {
                throw new UnsupportedOperationException("view <" + type + "> is not supported");
            }
            attribute = attribute.substring(colonPos);
        }
        try {
            AttrID id = AttrID.valueOf(attribute);
            if (id == AttrID.lastModifiedTime) {
                path.setTimes((FileTime)value, null, null);
            } else if (id == AttrID.lastAccessTime) {
                path.setTimes(null, (FileTime)value, null);
            } else if (id == AttrID.creationTime) {
                path.setTimes(null, null, (FileTime)value);
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException("'" + attribute + "' is unknown or read-only attribute");
        }
    }

    static Map<String, Object> readAttributes(JrtPath path, String attributes, LinkOption ... options) throws IOException {
        int colonPos = attributes.indexOf(58);
        boolean isJrtView = false;
        if (colonPos != -1) {
            String type;
            if (!(type = attributes.substring(0, colonPos++)).equals("basic") && !type.equals("jrt")) {
                throw new UnsupportedOperationException("view <" + type + "> is not supported");
            }
            isJrtView = true;
            attributes = attributes.substring(colonPos);
        }
        JrtFileAttributes jrtfas = path.getAttributes(new LinkOption[0]);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if ("*".equals(attributes)) {
            for (AttrID id : AttrID.values()) {
                map.put(id.name(), JrtFileAttributeView.attribute(id, jrtfas, isJrtView));
            }
        } else {
            String[] as;
            for (String a : as = attributes.split(",")) {
                map.put(a, JrtFileAttributeView.attribute(AttrID.valueOf(a), jrtfas, isJrtView));
            }
        }
        return map;
    }

    static Object attribute(AttrID id, JrtFileAttributes jrtfas, boolean isJrtView) {
        switch (id) {
            case size: {
                return jrtfas.size();
            }
            case creationTime: {
                return jrtfas.creationTime();
            }
            case lastAccessTime: {
                return jrtfas.lastAccessTime();
            }
            case lastModifiedTime: {
                return jrtfas.lastModifiedTime();
            }
            case isDirectory: {
                return jrtfas.isDirectory();
            }
            case isRegularFile: {
                return jrtfas.isRegularFile();
            }
            case isSymbolicLink: {
                return jrtfas.isSymbolicLink();
            }
            case isOther: {
                return jrtfas.isOther();
            }
            case fileKey: {
                return jrtfas.fileKey();
            }
            case compressedSize: {
                if (!isJrtView) break;
                return jrtfas.compressedSize();
            }
            case extension: {
                if (!isJrtView) break;
                return jrtfas.extension();
            }
        }
        return null;
    }

    private static enum AttrID {
        size,
        creationTime,
        lastAccessTime,
        lastModifiedTime,
        isDirectory,
        isRegularFile,
        isSymbolicLink,
        isOther,
        fileKey,
        compressedSize,
        extension;

    }
}

