/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

public class FloatCache {
    private float[] keyTable;
    private int[] valueTable;
    private int elementSize = 0;

    public FloatCache() {
        this(13);
    }

    public FloatCache(int n) {
        this.keyTable = new float[n];
        this.valueTable = new int[n];
    }

    public void clear() {
        int n = this.keyTable.length;
        while (--n >= 0) {
            this.keyTable[n] = 0.0f;
            this.valueTable[n] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(float f) {
        if (f == 0.0f) {
            int n = this.elementSize;
            for (int i = 0; i < n; ++i) {
                if (this.keyTable[i] != 0.0f) continue;
                int n2 = Float.floatToIntBits(f);
                int n3 = Float.floatToIntBits(this.keyTable[i]);
                if (n2 == Integer.MIN_VALUE && n3 == Integer.MIN_VALUE) {
                    return true;
                }
                if (n2 != 0 || n3 != 0) continue;
                return true;
            }
        } else {
            int n = this.elementSize;
            for (int i = 0; i < n; ++i) {
                if (this.keyTable[i] != f) continue;
                return true;
            }
        }
        return false;
    }

    public int put(float f, int n) {
        if (this.elementSize == this.keyTable.length) {
            this.keyTable = new float[this.elementSize * 2];
            System.arraycopy(this.keyTable, 0, this.keyTable, 0, this.elementSize);
            this.valueTable = new int[this.elementSize * 2];
            System.arraycopy(this.valueTable, 0, this.valueTable, 0, this.elementSize);
        }
        this.keyTable[this.elementSize] = f;
        this.valueTable[this.elementSize] = n;
        ++this.elementSize;
        return n;
    }

    public int putIfAbsent(float f, int n) {
        if (f == 0.0f) {
            int n2 = this.elementSize;
            for (int i = 0; i < n2; ++i) {
                if (this.keyTable[i] != 0.0f) continue;
                int n3 = Float.floatToIntBits(f);
                int n4 = Float.floatToIntBits(this.keyTable[i]);
                if (n3 == Integer.MIN_VALUE && n4 == Integer.MIN_VALUE) {
                    return this.valueTable[i];
                }
                if (n3 != 0 || n4 != 0) continue;
                return this.valueTable[i];
            }
        } else {
            int n5 = this.elementSize;
            for (int i = 0; i < n5; ++i) {
                if (this.keyTable[i] != f) continue;
                return this.valueTable[i];
            }
        }
        if (this.elementSize == this.keyTable.length) {
            this.keyTable = new float[this.elementSize * 2];
            System.arraycopy(this.keyTable, 0, this.keyTable, 0, this.elementSize);
            this.valueTable = new int[this.elementSize * 2];
            System.arraycopy(this.valueTable, 0, this.valueTable, 0, this.elementSize);
        }
        this.keyTable[this.elementSize] = f;
        this.valueTable[this.elementSize] = n;
        ++this.elementSize;
        return -n;
    }

    public String toString() {
        int n = this.elementSize;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < n; ++i) {
            if (this.keyTable[i] != 0.0f || this.keyTable[i] == 0.0f && this.valueTable[i] != 0) {
                stringBuffer.append(this.keyTable[i]).append("->").append(this.valueTable[i]);
            }
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

