"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var eventType_1 = require("../../lib/eventType");
electron_1.ipcRenderer.once(eventType_1.EVENT_TYPE.ABOUT.LOCALE_RENDER, function (event, labels) {
    for (var label in labels) {
        var labelElement = document.querySelector("[data-string=\"" + label + "\"]");
        if (labelElement) {
            labelElement.innerHTML = labels[label];
        }
    }
});
electron_1.ipcRenderer.once(eventType_1.EVENT_TYPE.ABOUT.LOADED, function (event, details) {
    var nameElement = document.getElementById('name');
    if (nameElement) {
        nameElement.innerHTML = details.productName;
    }
    var versionElement = document.getElementById('version');
    if (versionElement) {
        versionElement.innerHTML = details.electronVersion || 'Development';
    }
    var webappVersionElement = document.getElementById('webappVersion');
    if (webappVersionElement) {
        if (details.webappVersion) {
            webappVersionElement.innerHTML = details.webappVersion;
        }
        else {
            if (webappVersionElement.parentElement) {
                webappVersionElement.parentElement.remove();
            }
        }
    }
    var copyrightElement = document.getElementById('copyright');
    if (copyrightElement) {
        copyrightElement.innerHTML = details.copyright || '&copy; Wire Swiss GmbH';
    }
    var logoElement = document.getElementById('logo');
    if (logoElement) {
        logoElement.src = '../img/logo.256.png';
    }
    var labels = [];
    var dataStrings = document.querySelectorAll('[data-string]');
    for (var index in dataStrings) {
        var label = dataStrings[index];
        labels.push(label.dataset.string);
    }
    electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.ABOUT.LOCALE_VALUES, labels);
});
//# sourceMappingURL=preload-about.js.map