/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.options.ConfigurableSchemeExporter;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExporter;
import com.intellij.openapi.options.SchemeExporterEP;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemeActions<T extends Scheme> {
    private final Collection<String> mySchemeImportersNames;
    private final Collection<String> mySchemeExporterNames;
    protected final AbstractSchemesPanel<T, ?> mySchemesPanel;

    protected AbstractSchemeActions(@NotNull AbstractSchemesPanel<T, ?> schemesPanel) {
        if (schemesPanel == null) {
            AbstractSchemeActions.$$$reportNull$$$0(0);
        }
        this.mySchemesPanel = schemesPanel;
        this.mySchemeImportersNames = this.getSchemeImportersNames();
        this.mySchemeExporterNames = this.getSchemeExporterNames();
    }

    protected Collection<String> getSchemeImportersNames() {
        ArrayList<String> importersNames = new ArrayList<String>();
        for (SchemeImporterEP<T> importerEP : SchemeImporterEP.getExtensions(this.getSchemeType())) {
            importersNames.add(importerEP.name);
        }
        return importersNames;
    }

    private Collection<String> getSchemeExporterNames() {
        ArrayList<String> exporterNames = new ArrayList<String>();
        for (SchemeExporterEP<T> exporterEP : SchemeExporterEP.getExtensions(this.getSchemeType())) {
            exporterNames.add(exporterEP.name);
        }
        return exporterNames;
    }

    public final Collection<AnAction> getActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (this.mySchemesPanel.supportsProjectSchemes()) {
            actions.add((AnAction)new CopyToProjectAction());
            actions.add((AnAction)new CopyToIDEAction());
            actions.add((AnAction)new Separator());
        }
        actions.add((AnAction)new CopyAction());
        actions.add((AnAction)new RenameAction());
        this.addAdditionalActions(actions);
        actions.add((AnAction)new ResetAction());
        actions.add((AnAction)new DeleteAction());
        if (!this.mySchemeExporterNames.isEmpty()) {
            actions.add(AbstractSchemeActions.createImportExportAction(ApplicationBundle.message((String)"settings.editor.scheme.export", (Object[])new Object[0]), this.mySchemeExporterNames, (x$0, x$1) -> new ExportAction((String)x$0, (String)x$1)));
        }
        actions.add((AnAction)new Separator());
        if (!this.mySchemeImportersNames.isEmpty()) {
            actions.add(AbstractSchemeActions.createImportExportAction(ApplicationBundle.message((String)"settings.editor.scheme.import", (Object[])new Object[]{this.mySchemesPanel.getSchemeTypeName()}), this.mySchemeImportersNames, (x$0, x$1) -> new ImportAction((String)x$0, (String)x$1)));
        }
        return actions;
    }

    protected void addAdditionalActions(@NotNull List<? super AnAction> defaultActions) {
        if (defaultActions == null) {
            AbstractSchemeActions.$$$reportNull$$$0(1);
        }
    }

    private static AnAction createImportExportAction(@NotNull String groupName, @NotNull Collection<String> actionNames, final @NotNull BiFunction<? super String, ? super String, ? extends AnAction> createActionByName) {
        if (groupName == null) {
            AbstractSchemeActions.$$$reportNull$$$0(2);
        }
        if (actionNames == null) {
            AbstractSchemeActions.$$$reportNull$$$0(3);
        }
        if (createActionByName == null) {
            AbstractSchemeActions.$$$reportNull$$$0(4);
        }
        if (actionNames.size() == 1) {
            return createActionByName.apply((String)ContainerUtil.getFirstItem(actionNames), groupName + "...");
        }
        return new ImportExportActionGroup(groupName, actionNames){

            @Override
            @NotNull
            protected AnAction createAction(@NotNull String actionName) {
                if (actionName == null) {
                    1.$$$reportNull$$$0(0);
                }
                AnAction anAction = (AnAction)createActionByName.apply(actionName, actionName);
                if (anAction == null) {
                    1.$$$reportNull$$$0(1);
                }
                return anAction;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "actionName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemeActions$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createAction";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    protected void importScheme(@NotNull String importerName) {
        if (importerName == null) {
            AbstractSchemeActions.$$$reportNull$$$0(5);
        }
    }

    protected abstract void resetScheme(@NotNull T var1);

    protected abstract void duplicateScheme(@NotNull T var1, @NotNull String var2);

    protected void deleteScheme(@NotNull T scheme2) {
        if (scheme2 == null) {
            AbstractSchemeActions.$$$reportNull$$$0(6);
        }
        if (Messages.showOkCancelDialog((String)("Do you want to delete \"" + scheme2.getName() + "\" " + StringUtil.toLowerCase((String)this.mySchemesPanel.getSchemeTypeName()) + "?"), (String)("Delete " + this.mySchemesPanel.getSchemeTypeName()), (Icon)Messages.getQuestionIcon()) == 0) {
            this.mySchemesPanel.getModel().removeScheme(scheme2);
        }
    }

    protected void exportScheme(@NotNull T scheme2, @NotNull String exporterName) {
        SchemeExporter<T> exporter;
        if (scheme2 == null) {
            AbstractSchemeActions.$$$reportNull$$$0(7);
        }
        if (exporterName == null) {
            AbstractSchemeActions.$$$reportNull$$$0(8);
        }
        if ((exporter = SchemeExporterEP.getExporter(exporterName, this.getSchemeType())) != null) {
            Object config2 = null;
            if (exporter instanceof ConfigurableSchemeExporter && (config2 = ((ConfigurableSchemeExporter)exporter).getConfiguration(this.mySchemesPanel, scheme2)) == null) {
                return;
            }
            String ext = exporter.getExtension();
            FileSaverDialog saver = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(ApplicationBundle.message((String)"scheme.exporter.ui.file.chooser.title", (Object[])new Object[0]), ApplicationBundle.message((String)"scheme.exporter.ui.file.chooser.message", (Object[])new Object[0]), new String[]{ext}), this.getSchemesPanel());
            VirtualFileWrapper target2 = saver.save(null, SchemeManager.getDisplayName(scheme2) + "." + ext);
            if (target2 != null) {
                MessageType messageType;
                String message;
                VirtualFile targetFile = target2.getVirtualFile(true);
                if (targetFile != null) {
                    try {
                        Object finalConfig = config2;
                        WriteAction.run(() -> {
                            try (OutputStream outputStream = targetFile.getOutputStream((Object)this);){
                                if (exporter instanceof ConfigurableSchemeExporter) {
                                    ((ConfigurableSchemeExporter)exporter).exportScheme(scheme2, outputStream, finalConfig);
                                }
                                exporter.exportScheme(scheme2, outputStream);
                            }
                        });
                        message = ApplicationBundle.message((String)"scheme.exporter.ui.scheme.exported.message", (Object[])new Object[]{scheme2.getName(), this.getSchemesPanel().getSchemeTypeName(), targetFile.getPresentableUrl()});
                        messageType = MessageType.INFO;
                    }
                    catch (Exception e) {
                        message = ApplicationBundle.message((String)"scheme.exporter.ui.export.failed", (Object[])new Object[]{e.getMessage()});
                        messageType = MessageType.ERROR;
                    }
                } else {
                    message = ApplicationBundle.message((String)"scheme.exporter.ui.cannot.write.message", (Object[])new Object[0]);
                    messageType = MessageType.ERROR;
                }
                this.getSchemesPanel().showStatus(message, messageType);
            }
        }
    }

    protected abstract void onSchemeChanged(@Nullable T var1);

    protected abstract void renameScheme(@NotNull T var1, @NotNull String var2);

    protected void copyToProject(@NotNull T scheme2) {
        if (scheme2 == null) {
            AbstractSchemeActions.$$$reportNull$$$0(9);
        }
    }

    protected void copyToIDE(@NotNull T scheme2) {
        if (scheme2 == null) {
            AbstractSchemeActions.$$$reportNull$$$0(10);
        }
    }

    @NotNull
    protected SchemesModel<T> getModel() {
        SchemesModel<T> schemesModel = this.mySchemesPanel.getModel();
        if (schemesModel == null) {
            AbstractSchemeActions.$$$reportNull$$$0(11);
        }
        return schemesModel;
    }

    @Nullable
    protected final T getCurrentScheme() {
        return this.mySchemesPanel.getSelectedScheme();
    }

    protected abstract Class<T> getSchemeType();

    public final AbstractSchemesPanel<T, ?> getSchemesPanel() {
        return this.mySchemesPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemesPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultActions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createActionByName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importerName";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporterName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemeActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalActions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createImportExportAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importScheme";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteScheme";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "exportScheme";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyToProject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyToIDE";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExportAction
    extends DumbAwareAction {
        private final String myExporterName;

        ExportAction(@NotNull String exporterName, String exporterText) {
            if (exporterName == null) {
                ExportAction.$$$reportNull$$$0(0);
            }
            if (exporterText == null) {
                ExportAction.$$$reportNull$$$0(1);
            }
            super(exporterText);
            this.myExporterName = exporterName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme;
            if (e == null) {
                ExportAction.$$$reportNull$$$0(2);
            }
            if ((currentScheme = AbstractSchemeActions.this.getCurrentScheme()) != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.exportScheme(currentScheme, this.myExporterName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exporterName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exporterText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$ExportAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ImportAction
    extends DumbAwareAction {
        private final String myImporterName;

        ImportAction(@NotNull String importerName, String importerText) {
            if (importerName == null) {
                ImportAction.$$$reportNull$$$0(0);
            }
            if (importerText == null) {
                ImportAction.$$$reportNull$$$0(1);
            }
            super(importerText);
            this.myImporterName = importerName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ImportAction.$$$reportNull$$$0(2);
            }
            AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
            AbstractSchemeActions.this.importScheme(this.myImporterName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importerName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importerText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$ImportAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ImportExportActionGroup
    extends ActionGroup {
        private final Collection<String> myActionNames;

        ImportExportActionGroup(@NotNull String groupName, @NotNull Collection<String> actionNames) {
            if (groupName == null) {
                ImportExportActionGroup.$$$reportNull$$$0(0);
            }
            if (actionNames == null) {
                ImportExportActionGroup.$$$reportNull$$$0(1);
            }
            super(groupName, true);
            this.myActionNames = actionNames;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ArrayList<AnAction> namedActions = new ArrayList<AnAction>();
            for (String actionName : this.myActionNames) {
                namedActions.add(this.createAction(actionName));
            }
            AnAction[] anActionArray = namedActions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ImportExportActionGroup.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }

        @NotNull
        protected abstract AnAction createAction(@NotNull String var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionNames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/schemes/AbstractSchemeActions$ImportExportActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$ImportExportActionGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DeleteAction
    extends DumbAwareAction {
        DeleteAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.delete", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme;
            if (e == null) {
                DeleteAction.$$$reportNull$$$0(0);
            }
            if ((currentScheme = AbstractSchemeActions.this.getCurrentScheme()) != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.deleteScheme(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            boolean isEnabled;
            if (e == null) {
                DeleteAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            boolean bl = isEnabled = scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canDeleteScheme(scheme2);
            if (AbstractSchemeActions.this.mySchemesPanel.hideDeleteActionIfUnavailable()) {
                p.setEnabledAndVisible(isEnabled);
            } else {
                p.setEnabled(isEnabled);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$DeleteAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RenameAction
    extends DumbAwareAction {
        RenameAction() {
            super("Rename...");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RenameAction.$$$reportNull$$$0(0);
            }
            AbstractSchemeActions.this.mySchemesPanel.editCurrentSchemeName((currentScheme, newName) -> AbstractSchemeActions.this.renameScheme(currentScheme, (String)newName));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RenameAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canRenameScheme(scheme2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$RenameAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CopyAction
    extends DumbAwareAction {
        CopyAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.copy", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme;
            if (e == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            if ((currentScheme = AbstractSchemeActions.this.getCurrentScheme()) != null) {
                AbstractSchemeActions.this.mySchemesPanel.editNewSchemeName(SchemeManager.getDisplayName(currentScheme), AbstractSchemeActions.this.mySchemesPanel.supportsProjectSchemes() && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme), newName -> AbstractSchemeActions.this.duplicateScheme(currentScheme, (String)newName));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canDuplicateScheme(scheme2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$CopyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ResetAction
    extends DumbAwareAction {
        ResetAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.reset", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme;
            if (e == null) {
                ResetAction.$$$reportNull$$$0(0);
            }
            if ((currentScheme = AbstractSchemeActions.this.getCurrentScheme()) != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.resetScheme(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            if (scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canResetScheme(scheme2)) {
                p.setVisible(true);
                p.setEnabled(AbstractSchemeActions.this.mySchemesPanel.getModel().differsFromDefault(scheme2));
            } else {
                p.setEnabledAndVisible(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$ResetAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CopyToIDEAction
    extends DumbAwareAction {
        CopyToIDEAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.copy.to.ide", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme;
            if (e == null) {
                CopyToIDEAction.$$$reportNull$$$0(0);
            }
            if ((currentScheme = AbstractSchemeActions.this.getCurrentScheme()) != null && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme)) {
                AbstractSchemeActions.this.copyToIDE(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyToIDEAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(currentScheme != null && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$CopyToIDEAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CopyToProjectAction
    extends DumbAwareAction {
        CopyToProjectAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.copy.to.project", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme;
            if (e == null) {
                CopyToProjectAction.$$$reportNull$$$0(0);
            }
            if ((currentScheme = AbstractSchemeActions.this.getCurrentScheme()) != null && !AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme)) {
                AbstractSchemeActions.this.copyToProject(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyToProjectAction.$$$reportNull$$$0(1);
            }
            Presentation p = e.getPresentation();
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(currentScheme != null && !AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/application/options/schemes/AbstractSchemeActions$CopyToProjectAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

