/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.jetbrains.python.console.PyConsoleProcessFinishedException;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunicationUtil;
import com.jetbrains.python.console.PythonConsoleBackendServiceDisposable;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.console.protocol.CompletionOption;
import com.jetbrains.python.console.protocol.DebugValue;
import com.jetbrains.python.console.protocol.GetArrayResponse;
import com.jetbrains.python.console.protocol.KeyboardInterruptException;
import com.jetbrains.python.console.protocol.PythonConsoleFrontendService;
import com.jetbrains.python.console.pydev.AbstractConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebugValueExecutionService;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFrameListener;
import com.jetbrains.python.debugger.PyReferrersLoader;
import com.jetbrains.python.debugger.containerview.PyViewNumericContainerAction;
import com.jetbrains.python.debugger.pydev.GetVariableCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.thrift.TException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PydevConsoleCommunication
extends AbstractConsoleCommunication
implements PyFrameAccessor {
    private static final Logger LOG = Logger.getInstance(PydevConsoleCommunication.class);
    protected volatile boolean keyboardInterruption;
    protected volatile String inputReceived;
    protected volatile InterpreterResponse nextResponse;
    private final Object lock2 = new Object();
    private volatile boolean firstCommWorked = false;
    private boolean myExecuting;
    private PythonDebugConsoleCommunication myDebugCommunication;
    private boolean myNeedsMore = false;
    private int myFullValueSeq = 0;
    private final Map<Integer, List<PyFrameAccessor.PyAsyncValue<String>>> myCallbackHashMap = new ConcurrentHashMap<Integer, List<PyFrameAccessor.PyAsyncValue<String>>>();
    @Nullable
    private PythonConsoleView myConsoleView;
    private final List<PyFrameListener> myFrameListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @Nullable
    private XCompositeNode myCurrentRootNode;
    private final Object lock = new Object();

    public PydevConsoleCommunication(Project project) {
        super(project);
    }

    @NotNull
    protected abstract PythonConsoleBackendServiceDisposable getPythonConsoleBackendClient();

    public boolean handshake() {
        if (!this.isCommunicationClosed()) {
            try {
                return "PyCharm".equals(this.getPythonConsoleBackendClient().handshake());
            }
            catch (PyConsoleProcessFinishedException | CommunicationClosedException e) {
                return false;
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public void close() {
        PyDebugValueExecutionService.getInstance((Project)this.myProject).sessionStopped((PyFrameAccessor)this);
        this.myCallbackHashMap.clear();
        new Task.Backgroundable(this.myProject, "Close Console Communication", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    PydevConsoleCommunication.this.closeCommunication().get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    LOG.debug((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$1", "run"));
            }
        }.queue();
    }

    @NotNull
    public Future<?> closeAsync() {
        PyDebugValueExecutionService.getInstance((Project)this.myProject).sessionStopped((PyFrameAccessor)this);
        this.myCallbackHashMap.clear();
        Future<?> future2 = this.closeCommunication();
        if (future2 == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(0);
        }
        return future2;
    }

    @NotNull
    protected abstract Future<?> closeCommunication();

    protected abstract boolean isCommunicationClosed();

    private void execNotifyAboutMagic(List<String> commands, boolean isAutoMagic) {
        if (this.getConsoleFile() != null) {
            PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(this.getConsoleFile());
            consoleData.setIPythonAutomagic(isAutoMagic);
            consoleData.setIPythonMagicCommands(commands);
        }
    }

    private boolean execIPythonEditor(String path) {
        VirtualFile file;
        VirtualFile virtualFile = file = StringUtil.isEmpty((String)path) ? null : LocalFileSystem.getInstance().findFileByPath(path);
        if (file != null) {
            ApplicationManager.getApplication().invokeLater(() -> FileEditorManager.getInstance((Project)this.myProject).openFile(file, true));
            return true;
        }
        return false;
    }

    private void execNotifyFinished(boolean more) {
        this.myNeedsMore = more;
        this.setExecuting(false);
        this.notifyCommandExecuted(more);
    }

    private void setExecuting(boolean executing) {
        this.myExecuting = executing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execRequestInput() throws KeyboardInterruptException {
        this.waitingForInput = true;
        this.inputReceived = null;
        this.keyboardInterruption = false;
        boolean needInput = true;
        this.nextResponse = new InterpreterResponse(false, needInput);
        this.notifyInputRequested();
        while (this.inputReceived == null) {
            if (this.keyboardInterruption) {
                this.waitingForInput = false;
                throw new KeyboardInterruptException();
            }
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.inputReceived;
    }

    protected Pair<String, Boolean> exec(ConsoleCommunication.ConsoleCodeFragment command) {
        boolean more;
        this.setExecuting(true);
        try {
            more = command.isSingleLine() ? this.getPythonConsoleBackendClient().execLine(command.getText()) : this.getPythonConsoleBackendClient().execMultipleLines(command.getText());
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        if (more) {
            this.setExecuting(false);
        }
        return Pair.create(null, (Object)more);
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions(String text2, String actTok) throws Exception {
        if (this.myDebugCommunication != null && this.myDebugCommunication.isSuspended()) {
            List<PydevCompletionVariant> list = this.myDebugCommunication.getCompletions(text2, actTok);
            if (list == null) {
                PydevConsoleCommunication.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (this.waitingForInput) {
            List<PydevCompletionVariant> list = Collections.emptyList();
            if (list == null) {
                PydevConsoleCommunication.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<CompletionOption> fromServer = this.getPythonConsoleBackendClient().getCompletions(text2, actTok);
        List<PydevCompletionVariant> list = fromServer.stream().map(option -> PydevConsoleCommunication.toPydevCompletionVariant(option)).collect(Collectors.toList());
        if (list == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static PydevCompletionVariant toPydevCompletionVariant(@NotNull CompletionOption option) {
        if (option == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(4);
        }
        String args = String.join((CharSequence)" ", option.arguments);
        PydevCompletionVariant pydevCompletionVariant = new PydevCompletionVariant(option.name, option.documentation, args, option.type.getValue());
        if (pydevCompletionVariant == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(5);
        }
        return pydevCompletionVariant;
    }

    public String getDescription(String text2) throws Exception {
        if (this.myDebugCommunication != null && this.myDebugCommunication.isSuspended()) {
            return this.myDebugCommunication.getDescription(text2);
        }
        if (this.waitingForInput) {
            return "Unable to get description: waiting for input.";
        }
        ThrowableComputable doGetDesc = () -> this.getPythonConsoleBackendClient().getDescription(text2);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(doGetDesc, "Getting Description", true, this.myProject);
        }
        return (String)ApplicationManager.getApplication().executeOnPooledThread(() -> (String)doGetDesc.compute()).get(5L, TimeUnit.SECONDS);
    }

    public void execInterpreter(final ConsoleCommunication.ConsoleCodeFragment command, final Function<InterpreterResponse, Object> onResponseReceived) {
        if (this.myDebugCommunication != null && this.myDebugCommunication.isSuspended()) {
            this.myDebugCommunication.execInterpreter(command, onResponseReceived);
            return;
        }
        this.nextResponse = null;
        if (this.waitingForInput && this.myConsoleView != null && this.myConsoleView.isInitialized()) {
            this.inputReceived = command.getText();
            this.waitingForInput = false;
        } else {
            new Task.Backgroundable(this.myProject, "REPL Communication", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    boolean needInput = false;
                    try {
                        Pair executed = null;
                        int commAttempts = 0;
                        while (true) {
                            if (indicator.isCanceled()) {
                                return;
                            }
                            executed = PydevConsoleCommunication.this.exec(command);
                            String refusedConnPattern = "Failed to read servers response";
                            if (executed.first == null || ((String)executed.first).indexOf(refusedConnPattern) == -1 || PydevConsoleCommunication.this.firstCommWorked || commAttempts >= 3) break;
                            ++commAttempts;
                            Thread.sleep(250L);
                            executed = Pair.create((Object)"", (Object)executed.second);
                        }
                        PydevConsoleCommunication.this.firstCommWorked = true;
                        boolean more = (Boolean)executed.second;
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(more, needInput);
                    }
                    catch (ProcessCanceledException executed) {
                    }
                    catch (Exception e) {
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(false, needInput);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$2", "run"));
                }
            }.queue();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Waiting for REPL Response"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    progressIndicator.setText("Waiting for REPL response with 10s timeout");
                    progressIndicator.setIndeterminate(false);
                    long startTime = System.nanoTime();
                    while (PydevConsoleCommunication.this.nextResponse == null) {
                        if (progressIndicator.isCanceled()) {
                            LOG.debug("Canceled");
                            PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(false, false);
                        }
                        long time = System.nanoTime() - startTime;
                        progressIndicator.setFraction((double)time / 1.0E10);
                        if (time > 10000000000L) {
                            LOG.debug("Timeout exceeded");
                            PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(false, false);
                        }
                        Object object = PydevConsoleCommunication.this.lock2;
                        synchronized (object) {
                            try {
                                PydevConsoleCommunication.this.lock2.wait(20L);
                            }
                            catch (InterruptedException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                    if (PydevConsoleCommunication.this.nextResponse.more) {
                        PydevConsoleCommunication.this.myNeedsMore = true;
                        PydevConsoleCommunication.this.notifyCommandExecuted(true);
                    }
                    onResponseReceived.fun((Object)PydevConsoleCommunication.this.nextResponse);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$3", "run"));
                }
            });
        }
    }

    public void interrupt() {
        if (this.waitingForInput) {
            this.keyboardInterruption = true;
            return;
        }
        try {
            this.getPythonConsoleBackendClient().interrupt();
        }
        catch (PyConsoleProcessFinishedException | CommunicationClosedException | TException e) {
            LOG.error(e);
        }
    }

    public boolean isExecuting() {
        return this.myExecuting;
    }

    public boolean needsMore() {
        return this.myNeedsMore;
    }

    public PyDebugValue evaluate(String expression, boolean execute, boolean doTrunc) throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            try {
                List<DebugValue> debugValues = this.getPythonConsoleBackendClient().evaluate(expression);
                return PydevConsoleCommunicationUtil.createPyDebugValue(debugValues.iterator().next(), this);
            }
            catch (Exception e) {
                throw new PyDebuggerException("Evaluate in console failed", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public XValueChildrenList loadFrame() throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            try {
                List<DebugValue> frame = this.getPythonConsoleBackendClient().getFrame();
                return PydevConsoleCommunicationUtil.parseVars(frame, null, this);
            }
            catch (PyConsoleProcessFinishedException | CommunicationClosedException | TException e) {
                throw new PyDebuggerException("Get frame from console failed", e);
            }
        }
        return new XValueChildrenList();
    }

    public synchronized int getNextFullValueSeq() {
        ++this.myFullValueSeq;
        return this.myFullValueSeq;
    }

    public void loadAsyncVariablesValues(@NotNull List<PyFrameAccessor.PyAsyncValue<String>> pyAsyncValues) {
        if (pyAsyncValues == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(6);
        }
        PyDebugValueExecutionService.getInstance((Project)this.myProject).submitTask((PyFrameAccessor)this, () -> {
            try {
                ArrayList<String> evaluationExpressions = new ArrayList<String>();
                for (PyFrameAccessor.PyAsyncValue asyncValue : pyAsyncValues) {
                    evaluationExpressions.add(GetVariableCommand.composeName((PyDebugValue)asyncValue.getDebugValue()));
                }
                int seq = this.getNextFullValueSeq();
                this.myCallbackHashMap.put(seq, pyAsyncValues);
                this.getPythonConsoleBackendClient().loadFullValue(seq, evaluationExpressions);
            }
            catch (PyConsoleProcessFinishedException | CommunicationClosedException | TException e) {
                for (PyFrameAccessor.PyAsyncValue asyncValue : pyAsyncValues) {
                    PyDebugValue value = asyncValue.getDebugValue();
                    XValueNode node = value.getLastNode();
                    if (node == null || node.isObsolete()) continue;
                    if (e.getMessage().startsWith("Timeout") || e.getMessage().startsWith("Console already exited")) {
                        value.updateNodeValueAfterLoading(node, " ", "", "Loading timed out");
                        continue;
                    }
                    LOG.error(e);
                }
            }
        });
    }

    public XValueChildrenList loadVariable(PyDebugValue var) throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            try {
                List<DebugValue> ret = this.getPythonConsoleBackendClient().getVariable(GetVariableCommand.composeName((PyDebugValue)var));
                return PydevConsoleCommunicationUtil.parseVars(ret, var, this);
            }
            catch (PyConsoleProcessFinishedException | CommunicationClosedException e) {
                throw new PyDebuggerException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (TException e) {
                throw new PyDebuggerException("Get variable from console failed", (Throwable)e);
            }
        }
        return new XValueChildrenList();
    }

    public void setCurrentRootNode(@NotNull XCompositeNode node) {
        if (node == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(7);
        }
        this.myCurrentRootNode = node;
    }

    @Nullable
    public XCompositeNode getCurrentRootNode() {
        return this.myCurrentRootNode;
    }

    public void changeVariable(PyDebugValue variable, String value) throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            try {
                this.getPythonConsoleBackendClient().changeVariable(variable.getEvaluationExpression(), value);
            }
            catch (PyConsoleProcessFinishedException | CommunicationClosedException | TException e) {
                throw new PyDebuggerException("Get change variable", e);
            }
        }
    }

    @Nullable
    public PyReferrersLoader getReferrersLoader() {
        return null;
    }

    public ArrayChunk getArrayItems(PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            try {
                GetArrayResponse ret = this.getPythonConsoleBackendClient().getArray(var.getName(), rowOffset, colOffset, rows, cols, format);
                return PydevConsoleCommunicationUtil.createArrayChunk(ret, this);
            }
            catch (Exception e) {
                throw new PyDebuggerException("Evaluate in console failed", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public XSourcePosition getSourcePositionForName(String name, String parentType) {
        return null;
    }

    @Nullable
    public XSourcePosition getSourcePositionForType(String type) {
        return null;
    }

    public void connectToDebugger(int localPort, @NotNull Map<String, Boolean> dbgOpts, @NotNull Map<String, String> extraEnvs) throws Exception {
        if (dbgOpts == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(8);
        }
        if (extraEnvs == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(9);
        }
        if (this.waitingForInput) {
            throw new Exception("Can't connect debugger now, waiting for input");
        }
        try {
            this.getPythonConsoleBackendClient().connectToDebugger(localPort, dbgOpts, extraEnvs);
        }
        catch (PyConsoleProcessFinishedException | CommunicationClosedException | TException e) {
            throw new PyDebuggerException("pydevconsole failed to execute connectToDebugger", e);
        }
    }

    public void notifyCommandExecuted(boolean more) {
        super.notifyCommandExecuted(more);
        for (PyFrameListener listener2 : this.myFrameListeners) {
            listener2.frameChanged();
        }
    }

    public void setDebugCommunication(PythonDebugConsoleCommunication debugCommunication) {
        this.myDebugCommunication = debugCommunication;
    }

    public PythonDebugConsoleCommunication getDebugCommunication() {
        return this.myDebugCommunication;
    }

    public void setConsoleView(@Nullable PythonConsoleView consoleView) {
        this.myConsoleView = consoleView;
    }

    public void showNumericContainer(@NotNull PyDebugValue value) {
        if (value == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(10);
        }
        PyViewNumericContainerAction.showNumericViewer(this.myProject, value);
    }

    public void addFrameListener(@NotNull PyFrameListener listener2) {
        if (listener2 == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(11);
        }
        this.myFrameListeners.add(listener2);
    }

    @NotNull
    protected final PythonConsoleFrontendService.Iface createPythonConsoleFrontendHandler() {
        PythonConsoleFrontendHandler pythonConsoleFrontendHandler = new PythonConsoleFrontendHandler();
        if (pythonConsoleFrontendHandler == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(12);
        }
        return pythonConsoleFrontendHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleCommunication";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyAsyncValues";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbgOpts";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraEnvs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "closeAsync";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletions";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleCommunication";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toPydevCompletionVariant";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPythonConsoleFrontendHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toPydevCompletionVariant";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadAsyncVariablesValues";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentRootNode";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "connectToDebugger";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showNumericContainer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addFrameListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class CommunicationClosedException
    extends RuntimeException {
        protected CommunicationClosedException() {
        }
    }

    private class PythonConsoleFrontendHandler
    implements PythonConsoleFrontendService.Iface {
        private PythonConsoleFrontendHandler() {
        }

        @Override
        public void notifyFinished(boolean needsMoreInput) {
            PydevConsoleCommunication.this.execNotifyFinished(needsMoreInput);
        }

        @Override
        public String requestInput(String path) throws KeyboardInterruptException {
            return (String)PydevConsoleCommunication.this.execRequestInput();
        }

        @Override
        public void notifyAboutMagic(List<String> commands, boolean isAutoMagic) {
            PydevConsoleCommunication.this.execNotifyAboutMagic(commands, isAutoMagic);
        }

        @Override
        public void showConsole() {
            if (PydevConsoleCommunication.this.myConsoleView != null) {
                PydevConsoleCommunication.this.myConsoleView.setConsoleEnabled(true);
            }
        }

        @Override
        public void returnFullValue(int requestSeq, List<DebugValue> response) {
            block4: {
                List values = (List)PydevConsoleCommunication.this.myCallbackHashMap.remove(requestSeq);
                try {
                    List debugValues = response.stream().map(value -> PydevConsoleCommunicationUtil.createPyDebugValue(value, PydevConsoleCommunication.this)).collect(Collectors.toList());
                    for (int i = 0; i < debugValues.size(); ++i) {
                        PyDebugValue resultValue = (PyDebugValue)debugValues.get(i);
                        ((PyFrameAccessor.PyAsyncValue)values.get(i)).getCallback().ok((Object)resultValue.getValue());
                    }
                }
                catch (Exception e) {
                    if (values == null) break block4;
                    for (PyFrameAccessor.PyAsyncValue vars : values) {
                        vars.getCallback().error(new PyDebuggerException(response.toString()));
                    }
                }
            }
        }

        @Override
        public boolean IPythonEditor(String path, String line) {
            return PydevConsoleCommunication.this.execIPythonEditor(path);
        }
    }
}

