/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.Closeable;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PageTextWriter;
import org.sejda.impl.sambox.util.FontUtils;
import org.sejda.model.HorizontalAlign;
import org.sejda.model.VerticalAlign;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.SetHeaderFooterParameters;
import org.sejda.model.pdf.TextStampPattern;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PageNotFoundException;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetHeaderFooterWriter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SetHeaderFooterWriter.class);
    private PDDocumentHandler documentHandler;
    private PageTextWriter headerFooterWriter;
    private int totalPages;

    public SetHeaderFooterWriter(PDDocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
        this.headerFooterWriter = new PageTextWriter(documentHandler.getUnderlyingPDDocument());
        this.totalPages = documentHandler.getNumberOfPages();
    }

    public void write(String pattern, SetHeaderFooterParameters parameters, int currentFileCounter, String filename, TaskExecutionContext executionContext) throws TaskIOException, TaskExecutionException {
        PDFont font = (PDFont)ObjectUtils.defaultIfNull((Object)FontUtils.getStandardType1Font(parameters.getFont()), (Object)PDType1Font.HELVETICA);
        Double fontSize = (Double)ObjectUtils.defaultIfNull((Object)parameters.getFontSize(), (Object)10.0);
        HorizontalAlign hAlign = (HorizontalAlign)ObjectUtils.defaultIfNull((Object)parameters.getHorizontalAlign(), (Object)HorizontalAlign.CENTER);
        VerticalAlign vAlign = (VerticalAlign)ObjectUtils.defaultIfNull((Object)parameters.getVerticalAlign(), (Object)VerticalAlign.BOTTOM);
        SortedSet pages = parameters.getPages(this.totalPages);
        int userDefinedPageOffset = 0;
        if (parameters.getPageCountStartFrom() != null && !pages.isEmpty()) {
            userDefinedPageOffset = parameters.getPageCountStartFrom() - (Integer)pages.first();
        }
        Iterator iterator = pages.iterator();
        while (iterator.hasNext()) {
            int pageNumber = (Integer)iterator.next();
            int toLabelPageNumber = pageNumber + userDefinedPageOffset;
            String batesSeq = null;
            if (parameters.getBatesSequence() != null) {
                batesSeq = parameters.getBatesSequence().next();
            }
            String label = new TextStampPattern().withPage(toLabelPageNumber, this.totalPages).withBatesSequence(batesSeq).withFileSequence(String.valueOf(currentFileCounter)).withFilename(filename).build(pattern);
            LOG.debug("Applying {} '{}' to document page {}", new Object[]{vAlign == VerticalAlign.BOTTOM ? "footer" : "header", label, pageNumber});
            try {
                this.headerFooterWriter.write(this.documentHandler.getPage(pageNumber), hAlign, vAlign, label, font, fontSize, parameters.getColor());
            }
            catch (PageNotFoundException e) {
                executionContext.assertTaskIsLenient((Exception)((Object)e));
                ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)executionContext.notifiableTaskMetadata()).taskWarning(String.format("Page %d was skipped, could not be processed", pageNumber), (Exception)((Object)e));
            }
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.documentHandler);
    }
}

