/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSinkImpl;
import org.jetbrains.kotlin.fir.resolve.calls.InferenceComponents;
import org.jetbrains.kotlin.fir.resolve.calls.LambdaAnalyzer;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedLambdaAtom;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.StandardTypesKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.StubTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/PostponedArgumentsAnalyzer;", "", "lambdaAnalyzer", "Lorg/jetbrains/kotlin/fir/resolve/calls/LambdaAnalyzer;", "typeProvider", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "components", "Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/LambdaAnalyzer;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;)V", "getComponents", "()Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;", "getLambdaAnalyzer", "()Lorg/jetbrains/kotlin/fir/resolve/calls/LambdaAnalyzer;", "getTypeProvider", "()Lkotlin/jvm/functions/Function1;", "analyze", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$Context;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtomMarker;", "analyzeLambda", "lambda", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedLambdaAtom;", "resolve"})
public final class PostponedArgumentsAnalyzer {
    @NotNull
    private final LambdaAnalyzer lambdaAnalyzer;
    @NotNull
    private final Function1<FirExpression, FirTypeRef> typeProvider;
    @NotNull
    private final InferenceComponents components;

    public final void analyze(@NotNull PostponedArgumentsAnalyzer.Context c, @NotNull PostponedResolvedAtomMarker argument) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        PostponedResolvedAtomMarker postponedResolvedAtomMarker = argument;
        if (!(postponedResolvedAtomMarker instanceof ResolvedLambdaAtom)) {
            String string = "Unexpected resolved primitive: " + argument.getClass().getCanonicalName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.analyzeLambda(c, (ResolvedLambdaAtom)argument);
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzeLambda(PostponedArgumentsAnalyzer.Context c, ResolvedLambdaAtom lambda2) {
        void $this$mapTo$iv$iv;
        void returnArguments;
        List<FirExpression> $this$mapTo$iv$iv2;
        ConeKotlinType coneKotlinType;
        Object p1;
        ConeKotlinType $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map<TypeVariableMarker, StubTypeMarker> stubsForPostponedVariables;
        void $this$service$iv;
        FirSession firSession = this.components.getSession();
        Object object = StandardClassIds.INSTANCE.getUnit();
        boolean $i$f$service = false;
        Object object2 = $this$service$iv.getService(Reflection.getOrCreateKotlinClass(FirSymbolProvider.class));
        object = StandardTypesKt.invoke((ClassId)object, (FirSymbolProvider)object2);
        object2 = new ConeKotlinTypeProjection[]{};
        ConeLookupTagBasedType unitType = ResolveUtilsKt.constructType((ConeClassifierSymbol)object, object2, false);
        Map<TypeVariableMarker, StubTypeMarker> map2 = stubsForPostponedVariables = c.bindingStubsForPostponedVariables();
        object = c;
        boolean $i$f$mapKeys = false;
        void var8_12 = $this$mapKeys$iv;
        Map destination$iv$iv22 = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv22;
            boolean bl = false;
            TypeConstructorMarker typeConstructorMarker = MarkerExtensionsKt.freshTypeConstructor((TypeVariableMarker)entry.getKey(), c);
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            TypeConstructorMarker typeConstructorMarker2 = typeConstructorMarker;
            Object object3 = object2;
            boolean bl2 = false;
            Object v = it$iv$iv.getValue();
            object3.put((TypeConstructorMarker)typeConstructorMarker2, v);
        }
        object2 = destination$iv$iv22;
        TypeSubstitutorMarker currentSubstitutor2 = object.buildCurrentSubstitutor((Map<TypeConstructorMarker, ? extends StubTypeMarker>)object2);
        Function1<ConeKotlinType, ConeKotlinType> $fun$substitute$1 = new Function1<ConeKotlinType, ConeKotlinType>(currentSubstitutor2, c){
            final /* synthetic */ TypeSubstitutorMarker $currentSubstitutor;
            final /* synthetic */ PostponedArgumentsAnalyzer.Context $c;

            @NotNull
            public final ConeKotlinType invoke(@NotNull ConeKotlinType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                KotlinTypeMarker kotlinTypeMarker = MarkerExtensionsKt.safeSubstitute(this.$currentSubstitutor, this.$c, type2);
                if (kotlinTypeMarker == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                return (ConeKotlinType)kotlinTypeMarker;
            }
            {
                this.$currentSubstitutor = typeSubstitutorMarker;
                this.$c = context;
                super(1);
            }
        };
        ConeKotlinType coneKotlinType2 = lambda2.getReceiver();
        if (coneKotlinType2 != null) {
            $this$mapKeysTo$iv$iv = coneKotlinType2;
            boolean destination$iv$iv22 = false;
            $i$f$mapKeysTo = false;
            p1 = $this$mapKeysTo$iv$iv;
            boolean bl = false;
            coneKotlinType = $fun$substitute$1.invoke((ConeKotlinType)p1);
        } else {
            coneKotlinType = null;
        }
        ConeKotlinType receiver2 = coneKotlinType;
        Iterable $this$map$iv = lambda2.getParameters();
        boolean $i$f$map = false;
        p1 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo232 = false;
        for (Object e : $this$mapTo$iv$iv2) {
            void p12;
            ConeKotlinType bl = (ConeKotlinType)e;
            object = destination$iv$iv3;
            boolean bl3 = false;
            object2 = $fun$substitute$1.invoke((ConeKotlinType)p12);
            object.add(object2);
        }
        List parameters2 = (List)destination$iv$iv3;
        ConeKotlinType rawReturnType = lambda2.getReturnType();
        ConeKotlinType expectedTypeForReturnArguments = c.canBeProper(rawReturnType) ? $fun$substitute$1.invoke(rawReturnType) : (c.hasUpperOrEqualUnitConstraint(rawReturnType) ? (ConeKotlinType)unitType : null);
        Pair<List<FirExpression>, InferenceSession> $i$f$mapTo232 = this.lambdaAnalyzer.analyzeAndGetLambdaReturnArguments(lambda2.getAtom(), lambda2.isSuspend(), receiver2, parameters2, expectedTypeForReturnArguments, stubsForPostponedVariables);
        $this$mapTo$iv$iv2 = $i$f$mapTo232.component1();
        InferenceSession inferenceSession = $i$f$mapTo232.component2();
        Iterable $this$forEach$iv = (Iterable)returnArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirExpression it = (FirExpression)element$iv;
            boolean bl = false;
            CandidateFactoryKt.addSubsystemFromExpression(c, it);
        }
        CheckerSink checkerSink = new CheckerSinkImpl(this.components);
        Iterable iterable = (Iterable)returnArguments;
        boolean $i$f$map2 = false;
        Iterable it = iterable;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void atom;
            void it2;
            FirExpression firExpression2 = (FirExpression)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            ConeKotlinType coneKotlinType3 = lambda2.getReturnType();
            void var26_59 = it2;
            ConstraintSystemBuilder constraintSystemBuilder = c.getBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            ConeKotlinType p13 = coneKotlinType3;
            boolean bl6 = false;
            ConeKotlinType coneKotlinType4 = $fun$substitute$1.invoke(p13);
            ArgumentsKt.resolveArgumentExpression(constraintSystemBuilder, (FirExpression)var26_59, coneKotlinType4, lambda2.getAtom().getReturnTypeRef(), checkerSink, false, (Function1<? super PostponedResolvedAtomMarker, Unit>)new Function1<PostponedResolvedAtomMarker, Unit>((Ref.ObjectRef)atom){
                final /* synthetic */ Ref.ObjectRef $atom;

                public final void invoke(@NotNull PostponedResolvedAtomMarker it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    this.$atom.element = it;
                }
                {
                    this.$atom = objectRef;
                    super(1);
                }
            }, this.typeProvider);
            object2 = Unit.INSTANCE;
            object.add(object2);
        }
        List subResolvedKtPrimitives2 = (List)destination$iv$iv4;
        if (returnArguments.isEmpty()) {
            ConeKotlinType coneKotlinType5 = lambda2.getReturnType();
            boolean bl = false;
            boolean bl4 = false;
            ConeKotlinType p14 = coneKotlinType5;
            boolean bl8 = false;
            ConeKotlinType coneKotlinType6 = $fun$substitute$1.invoke(p14);
            c.getBuilder().addSubtypeConstraint(coneKotlinType6, unitType, SimpleConstraintSystemConstraintPosition.INSTANCE);
            c.getBuilder().addSubtypeConstraint(unitType, coneKotlinType6, SimpleConstraintSystemConstraintPosition.INSTANCE);
        }
        lambda2.setAnalyzed(true);
    }

    @NotNull
    public final LambdaAnalyzer getLambdaAnalyzer() {
        return this.lambdaAnalyzer;
    }

    @NotNull
    public final Function1<FirExpression, FirTypeRef> getTypeProvider() {
        return this.typeProvider;
    }

    @NotNull
    public final InferenceComponents getComponents() {
        return this.components;
    }

    public PostponedArgumentsAnalyzer(@NotNull LambdaAnalyzer lambdaAnalyzer, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider, @NotNull InferenceComponents components) {
        Intrinsics.checkParameterIsNotNull(lambdaAnalyzer, "lambdaAnalyzer");
        Intrinsics.checkParameterIsNotNull(typeProvider, "typeProvider");
        Intrinsics.checkParameterIsNotNull(components, "components");
        this.lambdaAnalyzer = lambdaAnalyzer;
        this.typeProvider = typeProvider;
        this.components = components;
    }
}

