"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var mobx_react_1 = require("mobx-react");
var react_1 = __importDefault(require("react"));
var icon_1 = require("../icons/icon");
var LegendItemComponent = /** @class */ (function (_super) {
    __extends(LegendItemComponent, _super);
    function LegendItemComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.closeColorPicker = function () {
            _this.setState({
                isColorPickerOpen: false,
            });
        };
        _this.toggleColorPicker = function () {
            _this.setState({
                isColorPickerOpen: !_this.state.isColorPickerOpen,
            });
        };
        _this.renderVisibilityButton = function (legendItemKey, isSeriesVisible) {
            if (isSeriesVisible === void 0) { isSeriesVisible = true; }
            var iconType = isSeriesVisible ? 'eye' : 'eyeClosed';
            return (react_1.default.createElement("div", { className: "echLegendItem__visibility" },
                react_1.default.createElement(icon_1.Icon, { type: iconType, "aria-label": "toggle visibility", onClick: _this.onVisibilityClick(legendItemKey) })));
        };
        _this.onLegendTitleClick = function (legendItemKey) { return function () {
            _this.props.chartStore.onLegendItemClick(legendItemKey);
        }; };
        // Keeping these as reference when we have a contextual panel
        // private onLegendItemPanelClose = () => {
        //   // tslint:disable-next-line:no-console
        //   console.log('close');
        // }
        // private onColorPickerChange = (legendItemKey: string) => (color: string) => {
        //   this.props.chartStore!.setSeriesColor(legendItemKey, color);
        // }
        // private renderPlusButton = () => {
        //   return (
        //     <EuiButtonIcon
        //       onClick={this.props.chartStore!.onLegendItemPlusClick}
        //       iconType="plusInCircle"
        //       aria-label="minus"
        //     />
        //   );
        // }
        // private renderMinusButton = () => {
        //   return (
        //     <EuiButtonIcon
        //       onClick={this.props.chartStore!.onLegendItemMinusClick}
        //       iconType="minusInCircle"
        //       aria-label="minus"
        //     />
        //   );
        // }
        _this.onVisibilityClick = function (legendItemKey) { return function (event) {
            if (event.shiftKey) {
                _this.props.chartStore.toggleSingleSeries(legendItemKey);
            }
            else {
                _this.props.chartStore.toggleSeriesVisibility(legendItemKey);
            }
        }; };
        _this.state = {
            isColorPickerOpen: false,
        };
        return _this;
    }
    LegendItemComponent.prototype.render = function () {
        var legendItemKey = this.props.legendItemKey;
        var _a = this.props, color = _a.color, label = _a.label, isSeriesVisible = _a.isSeriesVisible, displayValue = _a.displayValue, onMouseEnter = _a.onMouseEnter, onMouseLeave = _a.onMouseLeave;
        var onTitleClick = this.onLegendTitleClick(legendItemKey);
        var showLegendDisplayValue = this.props.chartStore.showLegendDisplayValue.get();
        var isSelected = legendItemKey === this.props.chartStore.selectedLegendItemKey.get();
        var hasDisplayValue = this.props.chartStore.showLegendDisplayValue.get();
        var hasTitleClickListener = Boolean(this.props.chartStore.onLegendItemClickListener);
        return (react_1.default.createElement("div", { className: "echLegendItem", onMouseEnter: onMouseEnter, onMouseLeave: onMouseLeave },
            this.renderColor(this.toggleColorPicker, color),
            this.renderVisibilityButton(legendItemKey, isSeriesVisible),
            this.renderTitle(label, onTitleClick, hasTitleClickListener, isSelected, hasDisplayValue),
            this.renderDisplayValue(displayValue, showLegendDisplayValue, isSeriesVisible)));
    };
    LegendItemComponent.prototype.renderColor = function (colorClickAction, color) {
        if (!color) {
            return null;
        }
        // TODO add color picler
        return (react_1.default.createElement("div", { className: "echLegendItem__color" },
            react_1.default.createElement(icon_1.Icon, { type: "dot", "aria-label": "series color", color: color, onClick: colorClickAction })));
    };
    LegendItemComponent.prototype.renderTitle = function (title, onTitleClick, hasTitleClickListener, isSelected, hasDisplayValue) {
        var _a;
        // TODO add contextual menu panel on click
        if (!title) {
            return null;
        }
        var titleClassNames = classnames_1.default('echLegendItem__title', (_a = {},
            _a['echLegendItem__title--hasClickListener'] = hasTitleClickListener,
            _a['echLegendItem__title--selected'] = isSelected,
            _a['echLegendItem__title--hasDisplayValue'] = hasDisplayValue,
            _a));
        return (react_1.default.createElement("div", { className: titleClassNames, title: title, onClick: onTitleClick }, title));
    };
    LegendItemComponent.prototype.renderDisplayValue = function (displayValue, show, isSeriesVisible) {
        var _a;
        if (!show) {
            return;
        }
        var displayValueClassNames = classnames_1.default('echLegendItem__displayValue', (_a = {},
            _a['echLegendItem__displayValue--hidden'] = !isSeriesVisible,
            _a));
        return (react_1.default.createElement("div", { className: displayValueClassNames, title: displayValue }, displayValue));
    };
    LegendItemComponent.displayName = 'LegendItem';
    return LegendItemComponent;
}(react_1.default.Component));
exports.LegendItem = mobx_react_1.inject('chartStore')(mobx_react_1.observer(LegendItemComponent));
//# sourceMappingURL=legend_item.js.map