// Generated by gmmproc 2.54.1 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_SDPMESSAGE_H
#define _GSTREAMERMM_SDPMESSAGE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Last reviewed on 2016-12-11 (1.10.0)
 */


#include <gst/sdp/gstsdpmessage.h>

namespace Gst
{

class Caps;

namespace SDP
{
/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var Result SDP_OK
 * A successful return value.
 * 
 *  @var Result SDP_EINVAL
 * A function was given invalid parameters.
 * 
 *  @enum Result
 * 
 * Return values for the SDP functions.
 *
 * @ingroup gstreamermmEnums
 */
enum Result
{
  SDP_OK = 0,
  SDP_EINVAL = -1
};


/** The contents of the SDP "k=" field which is used to convey encryption
 * keys.
 */
class Key
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Key;
  using BaseObjectType = GstSDPKey;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:


public:
  explicit Key(const GstSDPKey* gobject_);
  Key(const Key& other);
  Key(Key&& other);
  ~Key();

  GstSDPKey* gobj() { return &gobject_; }
  const GstSDPKey* gobj() const { return &gobject_; }

  Glib::ustring get_type() const;
  Glib::ustring get_data() const;

protected:
  GstSDPKey gobject_;


};

/** The contents of the SDP "m=" field with all related fields.
 */
class Media
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Media;
  using BaseObjectType = GstSDPMedia;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
  Media();
  Media(const Media& other);
  Media(Media&& other);
  virtual ~Media();

  GstSDPMedia* gobj() { return gobject_; }
  const GstSDPMedia* gobj() const { return gobject_; }

  
  /** Convert the contents of @a media to a text string.
   * 
   * @return A dynamically allocated string representing the media.
   */
  Glib::ustring as_text() const;
  
  /** Get the media description of @a media.
   * 
   * @return The media description.
   */
  Glib::ustring get_media() const;
  
  /** Set the media description of @a media to @a med.
   * 
   * @param med The media description.
   * @return Gst::SDP_OK.
   */
  Result set_media(const Glib::ustring& med);
  
  /** Get the port number for @a media.
   * 
   * @return The port number of @a media.
   */
  guint get_port() const;
  
  /** Get the number of ports for @a media.
   * 
   * @return The number of ports for @a media.
   */
  guint get_num_ports() const;
  
  /** Set the port information in @a media.
   * 
   * @param port The port number.
   * @param num_ports The number of ports.
   * @return Gst::SDP_OK.
   */
  Result set_port_info(guint port, guint num_ports);
  
  /** Get the transport protocol of @a media
   * 
   * @return The transport protocol of @a media.
   */
  Glib::ustring get_proto() const;
  
  /** Set the media transport protocol of @a media to @a proto.
   * 
   * @param proto The media transport protocol.
   * @return Gst::SDP_OK.
   */
  Result set_proto(const Glib::ustring& proto);
  
  /** Get the number of formats in @a media.
   * 
   * @return The number of formats in @a media.
   */
  guint formats_len() const;
  
  /** Get the format information at position @a idx in @a media.
   * 
   * @param idx An index.
   * @return The format at position @a idx.
   */
  Glib::ustring get_format(guint idx) const;
  
  /** Insert the format information to @a media at @a idx. When @a idx is -1,
   * the format is appended.
   * 
   * @param idx An index.
   * @param format The format.
   * @return Gst::SDP_OK.
   */
  Result insert_format(gint idx, const Glib::ustring& format);
  
  /** Replace the format information in @a media at @a idx with @a format.
   * 
   * @param idx An index.
   * @param format The format.
   * @return Gst::SDP_OK.
   */
  Result replace_format(guint idx, const Glib::ustring& format);
  
  /** Remove the format information in @a media at @a idx.
   * 
   * @param idx An index.
   * @return Gst::SDP_OK.
   */
  Result remove_format(guint idx);
  
  /** Add the format information to @a media.
   * 
   * @param format The format.
   * @return Gst::SDP_OK.
   */
  Result add_format(const Glib::ustring& format);
  
  /** Get the information of @a media
   * 
   * @return The information of @a media.
   */
  Glib::ustring get_information() const;
  
  /** Set the media information of @a media to @a information.
   * 
   * @param information The media information.
   * @return Gst::SDP_OK.
   */
  Result set_information(const Glib::ustring& information);
  
  /** Get the number of connection fields in @a media.
   * 
   * @return The number of connections in @a media.
   */
  guint connections_len() const;
  
  /** Remove the connection information in @a media at @a idx.
   * 
   * @param idx An index.
   * @return Gst::SDP_OK.
   */
  Result remove_connection(guint idx);
  
  /** Add the given connection parameters to @a media.
   * 
   * @param nettype The type of network. "IN" is defined to have the meaning
   * "Internet".
   * @param addrtype The type of address.
   * @param address The address.
   * @param ttl The time to live of the address.
   * @param addr_number The number of layers.
   * @return A Gst::SDPResult.
   */
  Result add_connection(const Glib::ustring& nettype, const Glib::ustring& addrtype, const Glib::ustring& address, guint ttl, guint addr_number);
  
  /** Get the number of bandwidth fields in @a media.
   * 
   * @return The number of bandwidths in @a media.
   */
  guint bandwidths_len() const;
  
  /** Remove the bandwidth information in @a media at @a idx.
   * 
   * @param idx An index.
   * @return Gst::SDP_OK.
   */
  Result remove_bandwidth(guint idx);
  
  /** Add the bandwidth information with @a bwtype and @a bandwith to @a media.
   * 
   * @param bwtype The bandwidth modifier type.
   * @param bandwith The bandwidth in kilobits per second.
   * @return Gst::SDP_OK.
   */
  Result add_bandwidth(const Glib::ustring& bwtype, guint bandwith);

 
  /** Get the encryption information from @a media.
   * 
   * @return A Gst::SDPKey.
   */
  Gst::SDP::Key get_key() const;

  
  /** Adds the encryption information to @a media.
   * 
   * @param key The encryption type.
   * @param data The encryption data.
   * @return A Gst::SDPResult.
   */
  Result set_key(const Glib::ustring& key, const Glib::ustring& data);
  
  /** Get the number of attribute fields in @a media.
   * 
   * @return The number of attributes in @a media.
   */
  guint attributes_len() const;
  
  /** Get the first attribute value for @a key in @a media.
   * 
   * @param key A key.
   * @return The first attribute value for @a key.
   */
  Glib::ustring get_attribute_val(const Glib::ustring& key) const;
  
  /** Get the @a nth attribute value for @a key in @a media.
   * 
   * @param key A key.
   * @param nth An index.
   * @return The @a nth attribute value.
   */
  Glib::ustring get_attribute_val(const Glib::ustring& key, guint nth) const;
  
  /** Remove the attribute in @a media at @a idx.
   * 
   * @param idx An index.
   * @return Gst::SDP_OK.
   */
  Result remove_attribute(guint idx);
  
  /** Add the attribute with @a key and @a value to @a media.
   * 
   * @param key A key.
   * @param value A value.
   * @return Gst::SDP_OK.
   */
  Result add_attribute(const Glib::ustring& key, const Glib::ustring& value);
  
  /** Mapping of caps from SDP fields:
   * 
   * a=rtpmap:(payload) (encoding_name)/(clock_rate)[/(encoding_params)]
   * 
   * a=framesize:(payload) (width)-(height)
   * 
   * a=fmtp:(payload) (param)[=(value)];...
   * 
   * @param pt A payload type.
   * @return A Gst::Caps, or <tt>nullptr</tt> if an error happened.
   */
  Glib::RefPtr<Gst::Caps> get_caps_from_media(int pt) const;
  
  /** Mapping of attributes of Gst::SDPMedia to Gst::Caps
   * 
   * @param caps A Gst::Caps.
   * @return A Gst::SDPResult.
   */
  Result attributes_to_caps(const Glib::RefPtr<Gst::Caps>& caps) const;

protected:
  GstSDPMedia *gobject_ = nullptr;


};

} // SDP
} // Gst


#endif /* _GSTREAMERMM_SDPMESSAGE_H */

