/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.PainlessScriptEngine;
import org.elasticsearch.painless.action.PainlessContextAction;
import org.elasticsearch.painless.action.PainlessExecuteAction;
import org.elasticsearch.painless.spi.PainlessExtension;
import org.elasticsearch.painless.spi.Whitelist;
import org.elasticsearch.painless.spi.WhitelistLoader;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.search.aggregations.pipeline.MovingFunctionScript;

public final class PainlessPlugin
extends Plugin
implements ScriptPlugin,
ExtensiblePlugin,
ActionPlugin {
    private static final Map<ScriptContext<?>, List<Whitelist>> whitelists;
    private final SetOnce<PainlessScriptEngine> painlessScriptEngine = new SetOnce();

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        HashMap contextsWithWhitelists = new HashMap();
        for (ScriptContext<?> context : contexts) {
            List<Whitelist> contextWhitelists = whitelists.get(context);
            if (contextWhitelists == null) {
                contextWhitelists = new ArrayList<Whitelist>(Whitelist.BASE_WHITELISTS);
            }
            contextsWithWhitelists.put(context, contextWhitelists);
        }
        this.painlessScriptEngine.set((Object)new PainlessScriptEngine(settings, contextsWithWhitelists));
        return (ScriptEngine)this.painlessScriptEngine.get();
    }

    public Collection<Module> createGuiceModules() {
        return Collections.singleton(b -> b.bind(PainlessScriptEngine.class).toInstance((Object)((PainlessScriptEngine)this.painlessScriptEngine.get())));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(CompilerSettings.REGEX_ENABLED);
    }

    public void reloadSPI(ClassLoader loader) {
        for (PainlessExtension extension : ServiceLoader.load(PainlessExtension.class, loader)) {
            for (Map.Entry entry : extension.getContextWhitelists().entrySet()) {
                List existing = whitelists.computeIfAbsent((ScriptContext)entry.getKey(), c -> new ArrayList(Whitelist.BASE_WHITELISTS));
                existing.addAll((Collection)entry.getValue());
            }
        }
    }

    public List<ScriptContext<?>> getContexts() {
        return Collections.singletonList(PainlessExecuteAction.PainlessTestScript.CONTEXT);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        actions.add(new ActionPlugin.ActionHandler((ActionType)PainlessExecuteAction.INSTANCE, PainlessExecuteAction.TransportAction.class, new Class[0]));
        actions.add(new ActionPlugin.ActionHandler((ActionType)PainlessContextAction.INSTANCE, PainlessContextAction.TransportAction.class, new Class[0]));
        return actions;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new PainlessExecuteAction.RestAction(settings, restController));
        handlers.add((RestHandler)new PainlessContextAction.RestAction(settings, restController));
        return handlers;
    }

    static {
        HashMap map = new HashMap();
        ArrayList<Whitelist> movFn = new ArrayList<Whitelist>(Whitelist.BASE_WHITELISTS);
        movFn.add(WhitelistLoader.loadFromResourceFiles(Whitelist.class, (String[])new String[]{"org.elasticsearch.aggs.movfn.txt"}));
        map.put(MovingFunctionScript.CONTEXT, movFn);
        ArrayList<Whitelist> scoreFn = new ArrayList<Whitelist>(Whitelist.BASE_WHITELISTS);
        scoreFn.add(WhitelistLoader.loadFromResourceFiles(Whitelist.class, (String[])new String[]{"org.elasticsearch.score.txt"}));
        map.put(ScoreScript.CONTEXT, scoreFn);
        whitelists = map;
    }
}

