/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jst.pagedesigner.utils.ICacheEntryCreator;

public class CacheManager {
    ICacheEntryCreator _creator;
    int _maxSize;
    Map _map = new HashMap();
    LinkedList _keys = new LinkedList();

    public CacheManager(ICacheEntryCreator creator, int maxSize) {
        this._creator = creator;
        this._maxSize = maxSize;
        if (this._maxSize <= 0) {
            this._maxSize = 10;
        }
    }

    public Object getEntry(Object key) {
        Object result = this._map.get(key);
        if (result == null) {
            if (this._map.size() >= this._maxSize) {
                Object keyRemove = this._keys.removeFirst();
                Object objToRemove = this._map.remove(keyRemove);
                this._creator.dispose(keyRemove, objToRemove);
            }
            result = this._creator.createEntry(key);
            this._keys.addLast(key);
            this._map.put(key, result);
            return result;
        }
        this._keys.remove(key);
        this._keys.addLast(key);
        return result;
    }

    public void disposeAll() {
        this._keys.clear();
        for (Object key : this._map.keySet()) {
            Object entry = this._map.get(key);
            this._creator.dispose(key, entry);
        }
        this._map.clear();
    }
}

