/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfigurationWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.command.ModifyPortCommand;
import org.eclipse.jst.server.tomcat.ui.internal.Messages;
import org.eclipse.jst.server.tomcat.ui.internal.TomcatUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ConfigurationPortEditorSection
extends ServerEditorSection {
    protected TomcatConfiguration tomcatConfiguration;
    protected boolean updating;
    protected Table ports;
    protected TableViewer viewer;
    protected PropertyChangeListener listener;
    static /* synthetic */ Class class$0;

    protected void addChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("modifyPort".equals(event.getPropertyName())) {
                    String id = (String)event.getOldValue();
                    Integer i = (Integer)event.getNewValue();
                    ConfigurationPortEditorSection.this.changePortNumber(id, i);
                }
            }
        };
        this.tomcatConfiguration.addPropertyChangeListener(this.listener);
    }

    protected void changePortNumber(String id, int port) {
        TableItem[] items = this.ports.getItems();
        int size = items.length;
        int i = 0;
        while (i < size) {
            ServerPort sp = (ServerPort)items[i].getData();
            if (sp.getId().equals(id)) {
                items[i].setData((Object)new ServerPort(id, sp.getName(), port, sp.getProtocol()));
                items[i].setText(1, String.valueOf(port));
                return;
            }
            ++i;
        }
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 450);
        section.setText(Messages.configurationEditorPortsSection);
        section.setDescription(Messages.configurationEditorPortsDescription);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.jst.server.tomcat.ui.tecp0000");
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.ports = toolkit.createTable(composite, 66304);
        this.ports.setHeaderVisible(true);
        this.ports.setLinesVisible(true);
        whs.setHelp((Control)this.ports, "org.eclipse.jst.server.tomcat.ui.tecp0002");
        TableLayout tableLayout = new TableLayout();
        TableColumn col = new TableColumn(this.ports, 0);
        col.setText(Messages.configurationEditorPortNameColumn);
        ColumnWeightData colData = new ColumnWeightData(15, 150, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        col = new TableColumn(this.ports, 0);
        col.setText(Messages.configurationEditorPortValueColumn);
        colData = new ColumnWeightData(8, 80, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        GridData data = new GridData(784);
        data.widthHint = 230;
        data.heightHint = 100;
        this.ports.setLayoutData((Object)data);
        this.ports.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(this.ports);
        this.viewer.setColumnProperties(new String[]{"name", "port"});
        this.initialize();
    }

    protected void setupPortEditors() {
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)this.ports);
        this.viewer.setCellEditors(cellEditorArray);
        ICellModifier cellModifier = new ICellModifier(){

            public Object getValue(Object element, String property) {
                ServerPort sp = (ServerPort)element;
                if (sp.getPort() < 0) {
                    return "-";
                }
                return String.valueOf(sp.getPort());
            }

            public boolean canModify(Object element, String property) {
                return "port".equals(property);
            }

            public void modify(Object element, String property, Object value) {
                try {
                    Item item = (Item)element;
                    ServerPort sp = (ServerPort)item.getData();
                    int port = Integer.parseInt((String)value);
                    ConfigurationPortEditorSection.this.execute((IUndoableOperation)new ModifyPortCommand((ITomcatConfigurationWorkingCopy)ConfigurationPortEditorSection.this.tomcatConfiguration, sp.getId(), port));
                }
                catch (Exception exception) {}
            }
        };
        this.viewer.setCellModifier(cellModifier);
        String os = System.getProperty("os.name");
        if (os != null && os.toLowerCase().indexOf("win") >= 0) {
            this.ports.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        int n = ConfigurationPortEditorSection.this.ports.getSelectionIndex();
                        ConfigurationPortEditorSection.this.viewer.editElement(ConfigurationPortEditorSection.this.ports.getItem(n).getData(), 1);
                    }
                    catch (Exception exception) {}
                }
            });
        }
    }

    public void dispose() {
        if (this.tomcatConfiguration != null) {
            this.tomcatConfiguration.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TomcatServer ts = (TomcatServer)this.server.getAdapter((Class)clazz);
        try {
            this.tomcatConfiguration = ts.getTomcatConfiguration();
        }
        catch (Exception exception) {}
        this.addChangeListener();
        this.initialize();
    }

    protected void initialize() {
        if (this.ports == null) {
            return;
        }
        this.ports.removeAll();
        Iterator iterator = this.tomcatConfiguration.getServerPorts().iterator();
        while (iterator.hasNext()) {
            ServerPort port = (ServerPort)iterator.next();
            TableItem item = new TableItem(this.ports, 0);
            String portStr = "-";
            if (port.getPort() >= 0) {
                portStr = String.valueOf(port.getPort());
            }
            String[] s = new String[]{port.getName(), portStr};
            item.setText(s);
            item.setImage(TomcatUIPlugin.getImage("port"));
            item.setData((Object)port);
        }
        if (this.readOnly) {
            this.viewer.setCellEditors(new CellEditor[2]);
            this.viewer.setCellModifier(null);
        } else {
            this.setupPortEditors();
        }
    }
}

