/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.configurators;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSequence;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EntityEditPage;
import org.jkiss.utils.CommonUtils;

public class OracleSequenceConfigurator
extends SQLObjectEditor<OracleSequence, OracleSchema> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((OracleSequence)command.getObject()).getName())) {
            throw new DBException("Sequence name cannot be empty");
        }
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleSequence> getObjectsCache(OracleSequence object) {
        return object.getSchema().sequenceCache;
    }

    protected OracleSequence createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        final OracleSchema schema = (OracleSchema)container;
        return (OracleSequence)new UITask<OracleSequence>(){

            protected OracleSequence runTask() {
                EntityEditPage page = new EntityEditPage((DBPDataSource)schema.getDataSource(), DBSEntityType.SEQUENCE);
                if (!page.edit()) {
                    return null;
                }
                OracleSequence sequence = new OracleSequence(schema, page.getEntityName());
                sequence.setIncrementBy(Long.valueOf(1L));
                sequence.setMinValue(new BigDecimal(0));
                sequence.setCycle(false);
                return sequence;
            }
        }.execute();
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        String sql = this.buildStatement((OracleSequence)command.getObject(), false);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Sequence", sql));
        String comment = this.buildComment((OracleSequence)command.getObject());
        if (comment != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment on Sequence", comment));
        }
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        String sql = this.buildStatement((OracleSequence)command.getObject(), true);
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter Sequence", sql));
        String comment = this.buildComment((OracleSequence)command.getObject());
        if (comment != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Comment on Sequence", comment));
        }
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        String sql = "DROP SEQUENCE " + ((OracleSequence)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL);
        SQLDatabasePersistAction action = new SQLDatabasePersistAction("Drop Sequence", sql);
        actions.add((DBEPersistAction)action);
    }

    private String buildStatement(OracleSequence sequence, Boolean forUpdate) {
        StringBuilder sb = new StringBuilder();
        if (forUpdate.booleanValue()) {
            sb.append("ALTER SEQUENCE ");
        } else {
            sb.append("CREATE SEQUENCE ");
        }
        sb.append(sequence.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
        if (sequence.getIncrementBy() != null) {
            sb.append("INCREMENT BY ").append(sequence.getIncrementBy()).append(" ");
        }
        if (sequence.getMinValue() != null) {
            sb.append("MINVALUE ").append(sequence.getMinValue()).append(" ");
        }
        if (sequence.getMaxValue() != null) {
            sb.append("MAXVALUE ").append(sequence.getMaxValue()).append(" ");
        }
        if (sequence.isCycle()) {
            sb.append("CYCLE ");
        } else {
            sb.append("NOCYCLE ");
        }
        if (sequence.getCacheSize() > 0L) {
            sb.append("CACHE ").append(sequence.getCacheSize()).append(" ");
        } else {
            sb.append("NOCACHE ");
        }
        if (sequence.isOrder()) {
            sb.append("ORDER ");
        } else {
            sb.append("NOORDER ");
        }
        return sb.toString();
    }

    private String buildComment(OracleSequence sequence) {
        if (!CommonUtils.isEmpty((String)sequence.getDescription())) {
            return "COMMENT ON SEQUENCE " + sequence.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)sequence, (String)sequence.getDescription());
        }
        return null;
    }
}

