/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.references;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.references.ReferencesResultsDecorator;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

class ReferencesResultsContainer
implements IResultSetContainer {
    private static final Log log = Log.getLog(ReferencesResultsContainer.class);
    private final IResultSetController parentController;
    private final Composite mainComposite;
    private final CSmartCombo<ReferenceKey> fkCombo;
    private ResultSetViewer dataViewer;
    private DBSDataContainer parentDataContainer;
    private DBSDataContainer dataContainer;
    private final List<ReferenceKey> referenceKeys = new ArrayList<ReferenceKey>();
    private ReferenceKey activeReferenceKey;
    private List<ResultSetRow> lastSelectedRows;

    ReferencesResultsContainer(Composite parent, IResultSetController parentController) {
        this.parentController = parentController;
        this.mainComposite = UIUtils.createComposite((Composite)parent, (int)1);
        Composite keySelectorPanel = UIUtils.createComposite((Composite)this.mainComposite, (int)2);
        keySelectorPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)keySelectorPanel, (String)"Reference");
        this.fkCombo = new CSmartCombo(keySelectorPanel, 12, (ILabelProvider)new RefKeyLabelProvider());
        this.fkCombo.addItem(null);
        this.fkCombo.setLayoutData((Object)new GridData(768));
        this.fkCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferencesResultsContainer.this.activeReferenceKey = (ReferenceKey)ReferencesResultsContainer.this.fkCombo.getSelectedItem();
                ReferencesResultsContainer.this.refreshKeyValues(true);
            }
        });
        Composite viewerContainer = new Composite(this.mainComposite, 0);
        viewerContainer.setLayoutData((Object)new GridData(1808));
        viewerContainer.setLayout((Layout)new FillLayout());
        this.dataViewer = new ResultSetViewer(viewerContainer, parentController.getSite(), this);
    }

    public ReferenceKey getActiveReferenceKey() {
        return this.activeReferenceKey;
    }

    public IResultSetPresentation getOwnerPresentation() {
        return this.parentController.getActivePresentation();
    }

    @Override
    public DBCExecutionContext getExecutionContext() {
        return this.parentController.getExecutionContext();
    }

    @Override
    public IResultSetController getResultSetController() {
        return this.dataViewer;
    }

    @Override
    public DBSDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public boolean isReadyToRun() {
        return true;
    }

    @Override
    public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
    }

    @Override
    public IResultSetDecorator createResultSetDecorator() {
        return new ReferencesResultsDecorator(this);
    }

    public Composite getControl() {
        return this.mainComposite;
    }

    public void refreshReferences() {
        DBSDataContainer newParentContainer = this.parentController.getDataContainer();
        if (newParentContainer != this.parentDataContainer) {
            this.refreshReferenceKeyList();
        } else if (this.dataContainer != null) {
            this.refreshKeyValues(false);
        }
    }

    private void refreshReferenceKeyList() {
        this.activeReferenceKey = null;
        this.referenceKeys.clear();
        UIUtils.syncExec(() -> {
            this.dataViewer.clearData();
            this.fkCombo.removeAll();
            this.dataViewer.showEmptyPresentation();
        });
        List<DBDAttributeBinding> visibleAttributes = this.parentController.getModel().getVisibleAttributes();
        if (visibleAttributes.isEmpty()) {
            return;
        }
        this.parentDataContainer = this.parentController.getDataContainer();
        final LinkedHashSet<DBSEntity> allEntities = new LinkedHashSet<DBSEntity>();
        for (DBDAttributeBinding attr : visibleAttributes) {
            DBSEntityAttribute entityAttribute = attr.getEntityAttribute();
            if (entityAttribute == null) continue;
            allEntities.add(entityAttribute.getParentObject());
        }
        if (!allEntities.isEmpty()) {
            new AbstractJob("Load reference keys"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        ArrayList<ReferenceKey> refs = new ArrayList<ReferenceKey>();
                        for (DBSEntity entity : allEntities) {
                            List associations = DBVUtils.getAllAssociations((DBRProgressMonitor)monitor, (DBSEntity)entity);
                            for (DBSEntityAssociation assoc : associations) {
                                List attrs;
                                if (!(assoc instanceof DBSEntityReferrer) || CommonUtils.isEmpty((Collection)(attrs = ((DBSEntityReferrer)assoc).getAttributeReferences(monitor)))) continue;
                                ReferenceKey referenceKey = new ReferenceKey(false, entity, assoc, attrs);
                                refs.add(referenceKey);
                            }
                            Collection references = entity.getReferences(monitor);
                            if (references == null) continue;
                            for (DBSEntityAssociation assoc : references) {
                                List attrs;
                                if (!(assoc instanceof DBSEntityReferrer) || CommonUtils.isEmpty((Collection)(attrs = ((DBSEntityReferrer)assoc).getAttributeReferences(monitor)))) continue;
                                ReferenceKey referenceKey = new ReferenceKey(true, entity, assoc, attrs);
                                refs.add(referenceKey);
                            }
                        }
                        List list = ReferencesResultsContainer.this.referenceKeys;
                        synchronized (list) {
                            ReferencesResultsContainer.this.referenceKeys.clear();
                            ReferencesResultsContainer.this.referenceKeys.addAll(refs);
                            if (!ReferencesResultsContainer.this.referenceKeys.isEmpty()) {
                                ReferencesResultsContainer.this.activeReferenceKey = (ReferenceKey)ReferencesResultsContainer.this.referenceKeys.get(0);
                            }
                        }
                        UIUtils.syncExec(() -> ReferencesResultsContainer.this.fillKeysCombo());
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void fillKeysCombo() {
        this.fkCombo.removeAll();
        if (this.referenceKeys.isEmpty()) {
            this.fkCombo.addItem(null);
        }
        for (ReferenceKey key : this.referenceKeys) {
            this.fkCombo.addItem((Object)key);
            if (key != this.activeReferenceKey) continue;
            this.fkCombo.select((Object)key);
        }
        if (this.activeReferenceKey != null) {
            this.refreshKeyValues(true);
        }
    }

    private void refreshKeyValues(boolean force) {
        if (this.activeReferenceKey == null) {
            return;
        }
        if (!(this.activeReferenceKey.refEntity instanceof DBSDataContainer)) {
            log.error((Object)"Referencing entity is not a data container");
            return;
        }
        this.dataContainer = (DBSDataContainer)this.activeReferenceKey.refEntity;
        try {
            List<ResultSetRow> selectedRows = this.parentController.getSelection().getSelectedRows();
            if (!force && CommonUtils.equalObjects(this.lastSelectedRows, selectedRows)) {
                return;
            }
            this.lastSelectedRows = selectedRows;
            if (selectedRows.isEmpty()) {
                this.dataViewer.clearData();
                this.dataViewer.showEmptyPresentation();
            } else if (this.activeReferenceKey.isReference) {
                this.dataViewer.navigateReference((DBRProgressMonitor)new VoidProgressMonitor(), this.parentController.getModel(), this.activeReferenceKey.refAssociation, selectedRows, false);
            } else {
                this.dataViewer.navigateAssociation((DBRProgressMonitor)new VoidProgressMonitor(), this.parentController.getModel(), this.activeReferenceKey.refAssociation, selectedRows, false);
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Can't shwo references", "Error opening '" + this.dataContainer.getName() + "' references", (Throwable)e);
        }
    }

    private static class RefKeyLabelProvider
    extends LabelProvider {
        private RefKeyLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element == null) {
                return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_ASSOCIATION);
            }
            ReferenceKey key = (ReferenceKey)element;
            return DBeaverIcons.getImage((DBPImage)(key.isReference ? UIIcon.ARROW_LEFT_ALL : UIIcon.ARROW_RIGHT_ALL));
        }

        public String getText(Object element) {
            if (element == null) {
                return "<No references>";
            }
            ReferenceKey key = (ReferenceKey)element;
            if (key.isReference) {
                return String.valueOf(key.refAssociation.getParentObject().getName()) + " (" + key.refAssociation.getName() + ")";
            }
            return String.valueOf(key.refAssociation.getReferencedConstraint().getParentObject().getName()) + " (" + key.refAssociation.getName() + ")";
        }
    }

    static class ReferenceKey {
        final boolean isReference;
        final DBSEntity refEntity;
        final DBSEntityAssociation refAssociation;
        final List<? extends DBSEntityAttributeRef> refAttributes;

        public ReferenceKey(boolean isReference, DBSEntity refEntity, DBSEntityAssociation refAssociation, List<? extends DBSEntityAttributeRef> refAttributes) {
            this.isReference = isReference;
            this.refEntity = refEntity;
            this.refAssociation = refAssociation;
            this.refAttributes = refAttributes;
        }
    }
}

