/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DBNProjectDatabases
extends DBNNode
implements DBNContainer,
DBPEventListener {
    private List<DBNDataSource> dataSources = new ArrayList<DBNDataSource>();
    private DBPDataSourceRegistry dataSourceRegistry;
    private volatile DBNNode[] children;
    private final IdentityHashMap<DBPDataSourceFolder, DBNLocalFolder> folderNodes = new IdentityHashMap();

    public DBNProjectDatabases(DBNProject parentNode, DBPDataSourceRegistry dataSourceRegistry) {
        super(parentNode);
        this.dataSourceRegistry = this.getModel().isGlobal() ? dataSourceRegistry : dataSourceRegistry.createCopy(parentNode.getProject(), false);
        this.dataSourceRegistry.addDataSourceListener(this);
        List<? extends DBPDataSourceContainer> projectDataSources = this.dataSourceRegistry.getDataSources();
        for (DBPDataSourceContainer dBPDataSourceContainer : projectDataSources) {
            this.addDataSource(dBPDataSourceContainer, false, false);
        }
    }

    @Override
    protected void dispose(boolean reflect) {
        for (DBNDataSource dataSource : this.dataSources) {
            dataSource.dispose(reflect);
        }
        this.dataSources.clear();
        this.folderNodes.clear();
        this.children = null;
        if (this.dataSourceRegistry != null) {
            this.dataSourceRegistry.removeDataSourceListener(this);
            this.dataSourceRegistry = null;
        }
        super.dispose(reflect);
    }

    @Override
    public String getNodeType() {
        return "connections";
    }

    public DBPDataSourceRegistry getDataSourceRegistry() {
        return this.dataSourceRegistry;
    }

    @Override
    public Object getValueObject() {
        return this.dataSourceRegistry;
    }

    @Override
    public String getChildrenType() {
        return ModelMessages.model_navigator_Connection;
    }

    public Class<DBPDataSourceContainer> getChildrenClass() {
        return DBPDataSourceContainer.class;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.getNodeName();
    }

    @Override
    public String getNodeName() {
        return "Connections";
    }

    @Override
    public String getNodeDescription() {
        return String.valueOf(this.getParentNode().getProject().getName()) + ModelMessages.model_navigator__connections;
    }

    @Override
    public DBNProject getParentNode() {
        return (DBNProject)super.getParentNode();
    }

    @Override
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_DATABASE_CATEGORY;
    }

    @Override
    public boolean allowsChildren() {
        return !this.dataSources.isEmpty() || !this.dataSourceRegistry.getRootFolders().isEmpty();
    }

    @Override
    public DBNNode[] getChildren(DBRProgressMonitor monitor) {
        if (this.children == null) {
            ArrayList<DBNNode> childNodes = new ArrayList<DBNNode>();
            for (DBPDataSourceFolder dBPDataSourceFolder : this.dataSourceRegistry.getAllFolders()) {
                DBNLocalFolder folderNode = this.folderNodes.get(dBPDataSourceFolder);
                if (folderNode == null) {
                    folderNode = new DBNLocalFolder(this, dBPDataSourceFolder);
                    this.folderNodes.put(dBPDataSourceFolder, folderNode);
                }
                if (dBPDataSourceFolder.getParent() != null) continue;
                childNodes.add(folderNode);
            }
            for (DBNDataSource dBNDataSource : this.dataSources) {
                if (dBNDataSource == null || dBNDataSource.getDataSourceContainer().getFolder() != null) continue;
                childNodes.add(dBNDataSource);
            }
            DBNProjectDatabases.sortNodes(childNodes);
            this.children = childNodes.toArray(new DBNNode[0]);
        }
        return this.children;
    }

    public void refreshChildren() {
        this.children = null;
        this.getModel().fireNodeUpdate(this, this, DBNEvent.NodeChange.STRUCT_REFRESH);
    }

    @Override
    public boolean allowsOpen() {
        return true;
    }

    @Override
    public String getNodeItemPath() {
        return this.getParentNode().getNodeItemPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBNLocalFolder getFolderNode(DBPDataSourceFolder folder) {
        IdentityHashMap<DBPDataSourceFolder, DBNLocalFolder> identityHashMap = this.folderNodes;
        synchronized (identityHashMap) {
            DBNLocalFolder folderNode = this.folderNodes.get(folder);
            if (folderNode == null) {
                folderNode = new DBNLocalFolder(this, folder);
                this.folderNodes.put(folder, folderNode);
            }
            return folderNode;
        }
    }

    public List<DBNDataSource> getDataSources() {
        return this.dataSources;
    }

    public DBNDataSource getDataSource(String id) {
        for (DBNDataSource dataSource : this.dataSources) {
            if (!dataSource.getDataSourceContainer().getId().equals(id)) continue;
            return dataSource;
        }
        return null;
    }

    private DBNDataSource addDataSource(@NotNull DBPDataSourceContainer descriptor, boolean reflect, boolean reveal) {
        DBNDataSource newNode = new DBNDataSource(this, descriptor);
        this.dataSources.add(newNode);
        this.children = null;
        if (reflect) {
            this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, reveal ? DBNEvent.NodeChange.SELECT : DBNEvent.NodeChange.REFRESH, newNode));
        }
        return newNode;
    }

    void removeDataSource(DBPDataSourceContainer descriptor) {
        DBNDataSource removedNode = null;
        Iterator<DBNDataSource> iter = this.dataSources.iterator();
        while (iter.hasNext()) {
            DBNDataSource dataSource = iter.next();
            if (dataSource.getObject() != descriptor) continue;
            iter.remove();
            removedNode = dataSource;
            break;
        }
        if (removedNode != null) {
            this.children = null;
            removedNode.dispose(true);
        }
    }

    @Override
    public void handleDataSourceEvent(DBPEvent event) {
        DBNModel model = this.getModel();
        switch (event.getAction()) {
            case OBJECT_ADD: {
                boolean parentFound;
                Object containerNode;
                if (event.getObject() instanceof DBPDataSourceContainer) {
                    this.addDataSource((DBPDataSourceContainer)event.getObject(), true, event.getEnabled() != null && event.getEnabled() != false);
                    break;
                }
                if (model.getNodeByObject(event.getObject()) != null) break;
                DBNDatabaseNode parentNode = null;
                if (event.getOptions() != null && (containerNode = event.getOptions().get("container")) instanceof DBNDatabaseFolder && event.getObject().getClass().getName().equals(((DBNDatabaseFolder)containerNode).getMeta().getType())) {
                    parentNode = (DBNDatabaseNode)containerNode;
                }
                if (parentNode == null) {
                    parentNode = model.getParentNode(event.getObject());
                }
                boolean bl = parentFound = parentNode != null;
                if (parentNode == null) {
                    parentNode = model.getParentNode(event.getObject());
                    parentFound = false;
                }
                if (parentNode == null) break;
                if (parentNode.getChildNodes() == null && parentNode.hasChildren(false)) {
                    final DBNDatabaseNode nodeToLoad = parentNode;
                    AbstractJob loaderJob = new AbstractJob("Load sibling nodes of new database object"){
                        {
                            super($anonymous0);
                            this.setUser(true);
                        }

                        @Override
                        protected IStatus run(DBRProgressMonitor monitor) {
                            try {
                                nodeToLoad.getChildren(monitor);
                            }
                            catch (Exception e) {
                                return GeneralUtils.makeExceptionStatus(e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    loaderJob.schedule();
                    try {
                        loaderJob.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!parentFound) {
                    parentNode = model.getParentNode(event.getObject());
                }
                if (parentNode == null || parentNode.getChildNodes() == null || parentNode.hasChildItem(event.getObject())) break;
                parentNode.addChildItem(event.getObject());
                break;
            }
            case OBJECT_REMOVE: {
                if (event.getObject() instanceof DBPDataSourceContainer) {
                    this.removeDataSource((DBPDataSourceContainer)event.getObject());
                    break;
                }
                DBNDatabaseNode node = model.getNodeByObject(event.getObject());
                if (node == null || !(node.getParentNode() instanceof DBNDatabaseNode)) break;
                ((DBNDatabaseNode)node.getParentNode()).removeChildItem(event.getObject());
                break;
            }
            case OBJECT_UPDATE: 
            case OBJECT_SELECT: {
                DBNEvent.NodeChange nodeChange;
                DBNDatabaseNode dbmNode = model.getNodeByObject(event.getObject());
                if (dbmNode == null) break;
                Boolean enabled = event.getEnabled();
                Object source = event;
                if (event.getAction() == DBPEvent.Action.OBJECT_SELECT) {
                    nodeChange = DBNEvent.NodeChange.REFRESH;
                    if (enabled != null && enabled.booleanValue()) {
                        source = DBNEvent.FORCE_REFRESH;
                    }
                } else {
                    nodeChange = enabled != null ? (enabled.booleanValue() ? DBNEvent.NodeChange.LOAD : DBNEvent.NodeChange.UNLOAD) : DBNEvent.NodeChange.REFRESH;
                    if (event.getData() == DBPEvent.REORDER) {
                        dbmNode.updateChildrenOrder(false);
                    }
                }
                model.fireNodeUpdate(source, dbmNode, nodeChange);
                if (!(event.getObject() instanceof DBPDataSourceContainer)) break;
                if (enabled != null && !enabled.booleanValue()) {
                    dbmNode.clearNode(false);
                    break;
                }
                if (event.getAction() != DBPEvent.Action.OBJECT_UPDATE) break;
                this.children = null;
                this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.UPDATE, this));
            }
        }
    }
}

