/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.json;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;

public class JSONUtils {
    private static final Log log = Log.getLog(JSONUtils.class);
    private static SimpleDateFormat dateFormat;

    static {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(tz);
    }

    public static String formatDate(Date date) {
        return dateFormat.format(date);
    }

    public static Date parseDate(String str) {
        if (CommonUtils.isEmpty((String)str)) {
            return null;
        }
        try {
            return dateFormat.parse(str);
        }
        catch (ParseException parseException) {
            log.error("Error parsing date");
            return new Date(0L);
        }
    }

    public static String formatISODate(Date date) {
        return "ISODate(\"" + JSONUtils.formatDate(date) + "\")";
    }

    public static String escapeJsonString(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\f': {
                    result.append("\\f");
                    break;
                }
                case '\b': {
                    result.append("\\b");
                    break;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    result.append("\\").append(c);
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    @NotNull
    public static JsonWriter field(@NotNull JsonWriter json, @NotNull String name, @Nullable String value) throws IOException {
        json.name(name);
        if (value == null) {
            json.nullValue();
        } else {
            json.value(value);
        }
        return json;
    }

    @NotNull
    public static JsonWriter fieldNE(@NotNull JsonWriter json, @NotNull String name, @Nullable String value) throws IOException {
        if (CommonUtils.isEmpty((String)value)) {
            return json;
        }
        json.name(name);
        json.value(value);
        return json;
    }

    @NotNull
    public static JsonWriter field(@NotNull JsonWriter json, @NotNull String name, long value) throws IOException {
        json.name(name);
        json.value(value);
        return json;
    }

    @NotNull
    public static JsonWriter field(@NotNull JsonWriter json, @NotNull String name, double value) throws IOException {
        json.name(name);
        json.value(value);
        return json;
    }

    @NotNull
    public static JsonWriter field(@NotNull JsonWriter json, @NotNull String name, boolean value) throws IOException {
        json.name(name);
        json.value(value);
        return json;
    }

    public static void serializeStringList(@NotNull JsonWriter json, @NotNull String tagName, @Nullable Collection<String> list) throws IOException {
        if (!CommonUtils.isEmpty(list)) {
            json.name(tagName);
            json.beginArray();
            for (String include : CommonUtils.safeCollection(list)) {
                json.value(include);
            }
            json.endArray();
        }
    }

    public static void serializeObjectList(@NotNull JsonWriter json, @NotNull String tagName, @Nullable Collection<Object> list) throws IOException {
        if (!CommonUtils.isEmpty(list)) {
            json.name(tagName);
            json.beginArray();
            for (Object value : CommonUtils.safeCollection(list)) {
                if (value == null) {
                    json.nullValue();
                    continue;
                }
                if (value instanceof Number) {
                    json.value((Number)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    json.value((Boolean)value);
                    continue;
                }
                json.value(value.toString());
            }
            json.endArray();
        }
    }

    public static void serializeProperties(@NotNull JsonWriter json, @NotNull String tagName, @Nullable Map<String, String> properties) throws IOException {
        if (!CommonUtils.isEmpty(properties)) {
            json.name(tagName);
            json.beginObject();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                JSONUtils.field(json, entry.getKey(), entry.getValue());
            }
            json.endObject();
        }
    }

    @NotNull
    public static Map<String, Object> parseMap(@NotNull Gson gson, @NotNull Reader reader) {
        return (Map)gson.fromJson(reader, new TypeToken<Map<String, Object>>(){}.getType());
    }

    @NotNull
    public static Map<String, Object> getObject(@NotNull Map<String, Object> map, @NotNull String name) {
        Map object = (Map)map.get(name);
        if (object == null) {
            return Collections.emptyMap();
        }
        return object;
    }

    @NotNull
    public static Iterable<Map.Entry<String, Map<String, Object>>> getNestedObjects(@NotNull Map<String, Object> map, @NotNull String name) {
        Map object = (Map)map.get(name);
        if (object == null) {
            return Collections.emptyList();
        }
        return object.entrySet();
    }

    public static <T> T getObjectProperty(Object object, String name) {
        if (object instanceof Map) {
            return (T)((Map)object).get(name);
        }
        log.error("Object " + object + " is not map");
        return null;
    }

    public static String getString(Map<String, Object> map, String name) {
        Object value = map.get(name);
        return value == null ? null : value.toString();
    }

    public static String getString(Map<String, Object> map, String name, String defValue) {
        Object value = map.get(name);
        return value == null ? defValue : value.toString();
    }

    public static boolean getBoolean(Map<String, Object> map, String name) {
        return CommonUtils.toBoolean((Object)map.get(name));
    }

    public static int getInteger(Map<String, Object> map, String name) {
        return CommonUtils.toInt((Object)map.get(name));
    }

    @NotNull
    public static Collection<Map<String, Object>> getObjectList(@NotNull Map<String, Object> map, @NotNull String name) {
        List list = (List)map.get(name);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static Map<String, String> deserializeProperties(Map<String, Object> map, String name) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Object propMap = map.get(name);
        if (propMap instanceof Map) {
            for (Map.Entry pe : ((Map)propMap).entrySet()) {
                result.put(CommonUtils.toString(pe.getKey()), CommonUtils.toString(pe.getValue()));
            }
        }
        return result;
    }

    public static List<String> deserializeStringList(Map<String, Object> map, String name) {
        ArrayList<String> result = new ArrayList<String>();
        Object propMap = map.get(name);
        if (propMap instanceof Collection) {
            for (Object pe : (Collection)propMap) {
                result.add(CommonUtils.toString(pe));
            }
        }
        return result;
    }
}

