/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.auto.value.AutoValue;
import com.google.errorprone.apply.AndroidImportOrganizer;
import com.google.errorprone.apply.AutoValue_ImportOrganizer_Import;
import com.google.errorprone.apply.BasicImportOrganizer;
import com.google.errorprone.apply.StaticOrder;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface ImportOrganizer {
    public static final ImportOrganizer STATIC_FIRST_ORGANIZER = new BasicImportOrganizer(StaticOrder.STATIC_FIRST);
    public static final ImportOrganizer STATIC_LAST_ORGANIZER = new BasicImportOrganizer(StaticOrder.STATIC_LAST);
    public static final ImportOrganizer ANDROID_STATIC_FIRST_ORGANIZER = new AndroidImportOrganizer(StaticOrder.STATIC_FIRST);
    public static final ImportOrganizer ANDROID_STATIC_LAST_ORGANIZER = new AndroidImportOrganizer(StaticOrder.STATIC_LAST);

    public OrganizedImports organizeImports(List<Import> var1);

    public static class OrganizedImports {
        private final StringBuilder importBlock = new StringBuilder();
        private int importCount;

        private void addGroup(Collection<Import> imports) {
            if (imports.isEmpty()) {
                return;
            }
            if (this.importBlock.length() != 0) {
                this.importBlock.append('\n');
            }
            this.importCount += imports.size();
            imports.forEach(i -> this.importBlock.append(i).append(";\n"));
        }

        public String asImportBlock() {
            return this.importBlock.toString();
        }

        public <K> OrganizedImports addGroups(Map<K, ? extends Collection<Import>> groups, Iterable<K> keys) {
            for (K key : keys) {
                Collection<Import> imports = groups.get(key);
                if (imports == null) continue;
                this.addGroup(imports);
            }
            return this;
        }

        int getImportCount() {
            return this.importCount;
        }
    }

    @AutoValue
    public static abstract class Import {
        public abstract boolean isStatic();

        public abstract String getType();

        static Import importOf(String importString) {
            boolean isStatic = importString.startsWith("import static ");
            String type = isStatic ? importString.substring("import static ".length()) : importString.substring("import ".length());
            return new AutoValue_ImportOrganizer_Import(isStatic, type);
        }

        public String toString() {
            return String.format("import%s %s", this.isStatic() ? " static" : "", this.getType());
        }
    }
}

