Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _atom = require('atom');

// View to display the snippets that a package has registered.

var PackageSnippetsView = (function () {
  function PackageSnippetsView(pack, snippetsProvider) {
    var _this = this;

    _classCallCheck(this, PackageSnippetsView);

    this.pack = pack;
    this.namespace = this.pack.name;
    this.snippetsProvider = snippetsProvider;
    this.packagePath = _path2['default'].join(pack.path, _path2['default'].sep);
    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.updateSnippetsView();

    var packagesWithSnippetsDisabled = atom.config.get('core.packagesWithSnippetsDisabled') || [];
    this.refs.snippetToggle.checked = !packagesWithSnippetsDisabled.includes(this.namespace);

    var changeHandler = function changeHandler(event) {
      event.stopPropagation();
      var value = _this.refs.snippetToggle.checked;
      if (value) {
        atom.config.removeAtKeyPath('core.packagesWithSnippetsDisabled', _this.namespace);
      } else {
        atom.config.pushAtKeyPath('core.packagesWithSnippetsDisabled', _this.namespace);
      }
      _this.updateSnippetsView();
    };

    this.refs.snippetToggle.addEventListener('change', changeHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.snippetToggle.removeEventListener('change', changeHandler);
    }));
  }

  _createClass(PackageSnippetsView, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'section',
        { className: 'section' },
        _etch2['default'].dom(
          'div',
          { className: 'section-heading icon icon-code' },
          'Snippets'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'checkbox' },
          _etch2['default'].dom(
            'label',
            { 'for': 'toggleSnippets' },
            _etch2['default'].dom('input', { id: 'toggleSnippets', className: 'input-checkbox', type: 'checkbox', ref: 'snippetToggle' }),
            _etch2['default'].dom(
              'div',
              { className: 'setting-title' },
              'Enable'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'setting-description' },
            'Disable this if you want to prevent this package’s snippets from appearing as suggestions or if you want to customize them in your snippets file.'
          )
        ),
        _etch2['default'].dom(
          'table',
          { className: 'package-snippets-table table native-key-bindings text', tabIndex: -1 },
          _etch2['default'].dom(
            'thead',
            null,
            _etch2['default'].dom(
              'tr',
              null,
              _etch2['default'].dom(
                'th',
                null,
                'Trigger'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Name'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Scope'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Body'
              )
            )
          ),
          _etch2['default'].dom('tbody', { ref: 'snippets' })
        )
      );
    }
  }, {
    key: 'getSnippetProperties',
    value: function getSnippetProperties() {
      var packageProperties = {};
      for (var _ref2 of this.snippetsProvider.getSnippets()) {
        var _name = _ref2.name;
        var properties = _ref2.properties;
        var selectorString = _ref2.selectorString;

        if (_name && _name.indexOf && _name.indexOf(this.packagePath) === 0) {
          var object = properties.snippets != null ? properties.snippets : {};
          for (var key in object) {
            var snippet = object[key];
            if (snippet != null) {
              snippet.selectorString = selectorString;
              if (packageProperties[key] == null) {
                packageProperties[key] = snippet;
              }
            }
          }
        }
      }

      return _underscorePlus2['default'].values(packageProperties).sort(function (snippet1, snippet2) {
        var prefix1 = snippet1.prefix != null ? snippet1.prefix : '';
        var prefix2 = snippet2.prefix != null ? snippet2.prefix : '';
        return prefix1.localeCompare(prefix2);
      });
    }
  }, {
    key: 'getSnippets',
    value: function getSnippets(callback) {
      var _this2 = this;

      var snippetsPackage = atom.packages.getLoadedPackage('snippets');
      var snippetsModule = snippetsPackage ? snippetsPackage.mainModule : null;
      if (snippetsModule) {
        if (snippetsModule.loaded) {
          callback(this.getSnippetProperties());
        } else {
          snippetsModule.onDidLoadSnippets(function () {
            return callback(_this2.getSnippetProperties());
          });
        }
      } else {
        callback([]); // eslint-disable-line standard/no-callback-literal
      }
    }
  }, {
    key: 'updateSnippetsView',
    value: function updateSnippetsView() {
      var _this3 = this;

      var packagesWithSnippetsDisabled = atom.config.get('core.packagesWithSnippetsDisabled') || [];
      var snippetsDisabled = packagesWithSnippetsDisabled.includes(this.namespace);

      this.getSnippets(function (snippets) {
        _this3.refs.snippets.innerHTML = '';

        if (snippetsDisabled) {
          _this3.refs.snippets.classList.add('text-subtle');
        } else {
          _this3.refs.snippets.classList.remove('text-subtle');
        }

        for (var _ref32 of snippets) {
          var body = _ref32.body;
          var bodyText = _ref32.bodyText;
          var _name2 = _ref32.name;
          var prefix = _ref32.prefix;
          var selectorString = _ref32.selectorString;

          if (_name2 == null) {
            _name2 = '';
          }

          if (prefix == null) {
            prefix = '';
          }

          if (body == null) {
            body = bodyText || '';
          }

          if (selectorString == null) {
            selectorString = '';
          }

          var row = document.createElement('tr');

          var prefixTd = document.createElement('td');
          prefixTd.classList.add('snippet-prefix');
          prefixTd.textContent = prefix;
          row.appendChild(prefixTd);

          var nameTd = document.createElement('td');
          nameTd.textContent = _name2;
          row.appendChild(nameTd);

          var scopeTd = document.createElement('td');
          scopeTd.classList.add('snippet-scope-name');
          scopeTd.textContent = selectorString;
          row.appendChild(scopeTd);

          var bodyTd = document.createElement('td');
          bodyTd.classList.add('snippet-body');
          row.appendChild(bodyTd);

          _this3.refs.snippets.appendChild(row);
          _this3.createButtonsForSnippetRow(bodyTd, { body: body, prefix: prefix, scope: selectorString, name: _name2 });
        }

        if (_this3.refs.snippets.children.length > 0) {
          _this3.element.style.display = '';
        } else {
          _this3.element.style.display = 'none';
        }
      });
    }
  }, {
    key: 'createButtonsForSnippetRow',
    value: function createButtonsForSnippetRow(td, _ref4) {
      var _this4 = this;

      var scope = _ref4.scope;
      var body = _ref4.body;
      var name = _ref4.name;
      var prefix = _ref4.prefix;

      var buttonContainer = document.createElement('div');
      buttonContainer.classList.add('btn-group', 'btn-group-xs');

      var viewButton = document.createElement('button');
      var copyButton = document.createElement('button');

      viewButton.setAttribute('type', 'button');
      viewButton.textContent = 'View';
      viewButton.classList.add('btn', 'snippet-view-btn');

      var tooltip = atom.tooltips.add(viewButton, {
        title: body,
        html: false,
        trigger: 'click',
        placement: 'auto left',
        'class': 'snippet-body-tooltip'
      });

      this.disposables.add(tooltip);

      copyButton.setAttribute('type', 'button');
      copyButton.textContent = 'Copy';
      copyButton.classList.add('btn', 'snippet-copy-btn');

      copyButton.addEventListener('click', function (event) {
        event.preventDefault();
        return _this4.writeSnippetToClipboard({ scope: scope, body: body, name: name, prefix: prefix });
      });

      buttonContainer.appendChild(viewButton);
      buttonContainer.appendChild(copyButton);

      td.appendChild(buttonContainer);
    }
  }, {
    key: 'writeSnippetToClipboard',
    value: function writeSnippetToClipboard(_ref5) {
      var scope = _ref5.scope;
      var body = _ref5.body;
      var name = _ref5.name;
      var prefix = _ref5.prefix;

      var content = undefined;
      var extension = _path2['default'].extname(this.snippetsProvider.getUserSnippetsPath());
      body = body.replace(/\n/g, '\\n').replace(/\t/g, '\\t');
      if (extension === '.cson') {
        body = body.replace(/'/g, '\\\'');
        content = '\n\'' + scope + '\':\n  \'' + name + '\':\n    \'prefix\': \'' + prefix + '\'\n    \'body\': \'' + body + '\'\n';
      } else {
        body = body.replace(/"/g, '\\"');
        content = '\n  "' + scope + '": {\n    "' + name + '": {\n      "prefix": "' + prefix + '",\n      "body": "' + body + '"\n    }\n  }\n';
      }

      atom.clipboard.write(content);
    }
  }]);

  return PackageSnippetsView;
})();

exports['default'] = PackageSnippetsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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