"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareHeadRefForcePushedEventView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _timeago = _interopRequireDefault(require("../timeago"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareHeadRefForcePushedEventView extends _react["default"].Component {
  render() {
    const {
      actor,
      beforeCommit,
      afterCommit,
      createdAt
    } = this.props.item;
    const {
      headRefName,
      headRepositoryOwner,
      repository
    } = this.props.issueish;
    const branchPrefix = headRepositoryOwner.login !== repository.owner.login ? `${headRepositoryOwner.login}:` : '';
    return _react["default"].createElement("div", {
      className: "head-ref-force-pushed-event"
    }, _react["default"].createElement(_octicon["default"], {
      className: "pre-timeline-item-icon",
      icon: "repo-force-push"
    }), actor && _react["default"].createElement("img", {
      className: "author-avatar",
      src: actor.avatarUrl,
      alt: actor.login,
      title: actor.login
    }), _react["default"].createElement("span", {
      className: "head-ref-force-pushed-event-header"
    }, _react["default"].createElement("span", {
      className: "username"
    }, actor ? actor.login : 'someone'), " force-pushed the ", branchPrefix + headRefName, " branch from ", this.renderCommit(beforeCommit, 'an old commit'), " to", ' ', this.renderCommit(afterCommit, 'a new commit'), " at ", _react["default"].createElement(_timeago["default"], {
      time: createdAt
    })));
  }

  renderCommit(commit, description) {
    if (!commit) {
      return description;
    }

    return _react["default"].createElement("span", {
      className: "sha"
    }, commit.oid.slice(0, 8));
  }

}

exports.BareHeadRefForcePushedEventView = BareHeadRefForcePushedEventView;

_defineProperty(BareHeadRefForcePushedEventView, "propTypes", {
  item: _propTypes["default"].shape({
    actor: _propTypes["default"].shape({
      avatarUrl: _propTypes["default"].string.isRequired,
      login: _propTypes["default"].string.isRequired
    }),
    beforeCommit: _propTypes["default"].shape({
      oid: _propTypes["default"].string.isRequired
    }),
    afterCommit: _propTypes["default"].shape({
      oid: _propTypes["default"].string.isRequired
    }),
    createdAt: _propTypes["default"].string.isRequired
  }).isRequired,
  issueish: _propTypes["default"].shape({
    headRefName: _propTypes["default"].string.isRequired,
    headRepositoryOwner: _propTypes["default"].shape({
      login: _propTypes["default"].string.isRequired
    }),
    repository: _propTypes["default"].shape({
      owner: _propTypes["default"].shape({
        login: _propTypes["default"].string.isRequired
      }).isRequired
    }).isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareHeadRefForcePushedEventView, {
  issueish: function () {
    const node = require("./__generated__/headRefForcePushedEventView_issueish.graphql");

    if (node.hash && node.hash !== "4c639070afc4a02cedf062d836d0dd7f") {
      console.error("The definition of 'headRefForcePushedEventView_issueish' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/headRefForcePushedEventView_issueish.graphql");
  },
  item: function () {
    const node = require("./__generated__/headRefForcePushedEventView_item.graphql");

    if (node.hash && node.hash !== "fc403545674c57c1997c870805101ffb") {
      console.error("The definition of 'headRefForcePushedEventView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/headRefForcePushedEventView_item.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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