"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEndpoint = getEndpoint;

// API endpoint for a GitHub instance, either dotcom or an Enterprise installation.
class Endpoint {
  constructor(host, apiHost, apiRouteParts) {
    this.host = host;
    this.apiHost = apiHost;
    this.apiRoute = apiRouteParts.map(encodeURIComponent).join('/');
  }

  getRestURI(...parts) {
    const sep = parts.length > 0 ? '/' : '';
    return this.getRestRoot() + sep + parts.map(encodeURIComponent).join('/');
  }

  getGraphQLRoot() {
    return this.getRestURI('graphql');
  }

  getRestRoot() {
    const sep = this.apiRoute !== '' ? '/' : '';
    return `https://${this.apiHost}${sep}${this.apiRoute}`;
  }

  getHost() {
    return this.host;
  }

  getLoginAccount() {
    return `https://${this.apiHost}`;
  }

} // API endpoint for GitHub.com


const dotcomEndpoint = new Endpoint('github.com', 'api.github.com', []);

function getEndpoint(host) {
  if (host === 'github.com') {
    return dotcomEndpoint;
  } else {
    return new Endpoint(host, host, ['api', 'v3']);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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