"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareIssueishDetailController = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _issueDetailView = _interopRequireDefault(require("../views/issue-detail-view"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _reviewsItem = _interopRequireDefault(require("../items/reviews-item"));

var _reporterProxy = require("../reporter-proxy");

var _prCheckoutController = _interopRequireDefault(require("./pr-checkout-controller"));

var _prDetailView = _interopRequireDefault(require("../views/pr-detail-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareIssueishDetailController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "openCommit", async ({
      sha
    }) => {
      /* istanbul ignore if */
      if (!this.props.workdirPath) {
        return;
      }

      const uri = _commitDetailItem["default"].buildURI(this.props.workdirPath, sha);

      await this.props.workspace.open(uri, {
        pending: true
      });
      (0, _reporterProxy.addEvent)('open-commit-in-pane', {
        "package": 'github',
        from: this.constructor.name
      });
    });

    _defineProperty(this, "openReviews", async () => {
      /* istanbul ignore if */
      if (this.getTypename() !== 'PullRequest') {
        return;
      }

      const uri = _reviewsItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.repository.owner.login,
        repo: this.props.repository.name,
        number: this.props.issueishNumber,
        workdir: this.props.workdirPath
      });

      await this.props.workspace.open(uri);
      (0, _reporterProxy.addEvent)('open-reviews-tab', {
        "package": 'github',
        from: this.constructor.name
      });
    });
  }

  componentDidMount() {
    this.updateTitle();
  }

  componentDidUpdate() {
    this.updateTitle();
  }

  updateTitle() {
    const {
      repository
    } = this.props;

    if (repository && (repository.issue || repository.pullRequest)) {
      let prefix, issueish;

      if (this.getTypename() === 'PullRequest') {
        prefix = 'PR:';
        issueish = repository.pullRequest;
      } else {
        prefix = 'Issue:';
        issueish = repository.issue;
      }

      const title = `${prefix} ${repository.owner.login}/${repository.name}#${issueish.number} — ${issueish.title}`;
      this.props.onTitleChange(title);
    }
  }

  render() {
    const {
      repository
    } = this.props;

    if (!repository || !repository.issue || !repository.pullRequest) {
      return _react["default"].createElement("div", null, "Issue/PR #", this.props.issueishNumber, " not found"); // TODO: no PRs
    }

    if (this.getTypename() === 'PullRequest') {
      return _react["default"].createElement(_prCheckoutController["default"], {
        repository: repository,
        pullRequest: repository.pullRequest,
        localRepository: this.props.localRepository,
        isAbsent: this.props.isAbsent,
        isLoading: this.props.isLoading,
        isPresent: this.props.isPresent,
        isMerging: this.props.isMerging,
        isRebasing: this.props.isRebasing,
        branches: this.props.branches,
        remotes: this.props.remotes
      }, checkoutOp => _react["default"].createElement(_prDetailView["default"], {
        relay: this.props.relay,
        repository: this.props.repository,
        pullRequest: this.props.repository.pullRequest,
        checkoutOp: checkoutOp,
        localRepository: this.props.localRepository,
        reviewCommentsLoading: this.props.reviewCommentsLoading,
        reviewCommentsTotalCount: this.props.reviewCommentsTotalCount,
        reviewCommentsResolvedCount: this.props.reviewCommentsResolvedCount,
        reviewCommentThreads: this.props.reviewCommentThreads,
        endpoint: this.props.endpoint,
        token: this.props.token,
        workspace: this.props.workspace,
        commands: this.props.commands,
        keymaps: this.props.keymaps,
        tooltips: this.props.tooltips,
        config: this.props.config,
        openCommit: this.openCommit,
        openReviews: this.openReviews,
        switchToIssueish: this.props.switchToIssueish,
        destroy: this.props.destroy,
        reportMutationErrors: this.props.reportMutationErrors,
        itemType: this.props.itemType,
        refEditor: this.props.refEditor,
        initChangedFilePath: this.props.initChangedFilePath,
        initChangedFilePosition: this.props.initChangedFilePosition,
        selectedTab: this.props.selectedTab,
        onTabSelected: this.props.onTabSelected,
        onOpenFilesTab: this.props.onOpenFilesTab,
        workdirPath: this.props.workdirPath
      }));
    } else {
      return _react["default"].createElement(_issueDetailView["default"], {
        repository: repository,
        issue: repository.issue,
        switchToIssueish: this.props.switchToIssueish,
        tooltips: this.props.tooltips,
        reportMutationErrors: this.props.reportMutationErrors
      });
    }
  }

  getTypename() {
    const {
      repository
    } = this.props;
    /* istanbul ignore if */

    if (!repository) {
      return null;
    }
    /* istanbul ignore if */


    if (!repository.pullRequest) {
      return null;
    }

    return repository.pullRequest.__typename;
  }

}

exports.BareIssueishDetailController = BareIssueishDetailController;

_defineProperty(BareIssueishDetailController, "propTypes", {
  // Relay response
  relay: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].shape({
    name: _propTypes["default"].string.isRequired,
    owner: _propTypes["default"].shape({
      login: _propTypes["default"].string.isRequired
    }).isRequired,
    pullRequest: _propTypes["default"].any,
    issue: _propTypes["default"].any
  }),
  // Local Repository model properties
  localRepository: _propTypes["default"].object.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  isMerging: _propTypes["default"].bool.isRequired,
  isRebasing: _propTypes["default"].bool.isRequired,
  isAbsent: _propTypes["default"].bool.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  isPresent: _propTypes["default"].bool.isRequired,
  workdirPath: _propTypes["default"].string,
  issueishNumber: _propTypes["default"].number.isRequired,
  // Review comment threads
  reviewCommentsLoading: _propTypes["default"].bool.isRequired,
  reviewCommentsTotalCount: _propTypes["default"].number.isRequired,
  reviewCommentsResolvedCount: _propTypes["default"].number.isRequired,
  reviewCommentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })).isRequired,
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // Action methods
  onTitleChange: _propTypes["default"].func.isRequired,
  switchToIssueish: _propTypes["default"].func.isRequired,
  destroy: _propTypes["default"].func.isRequired,
  reportMutationErrors: _propTypes["default"].func.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  refEditor: _propTypes2.RefHolderPropType.isRequired,
  // For opening files changed tab
  initChangedFilePath: _propTypes["default"].string,
  initChangedFilePosition: _propTypes["default"].number,
  selectedTab: _propTypes["default"].number.isRequired,
  onTabSelected: _propTypes["default"].func.isRequired,
  onOpenFilesTab: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueishDetailController, {
  repository: function () {
    const node = require("./__generated__/issueishDetailController_repository.graphql");

    if (node.hash && node.hash !== "b280de21fe28a74a5cbf1c93d3585955") {
      console.error("The definition of 'issueishDetailController_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueishDetailController_repository.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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