/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher.confined;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.JUnitLauncherTask;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.ListenerDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.TestDefinition;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.StringResource;

public class TestClasses
extends TestDefinition {
    private final Resources resources = new Resources();

    public void add(ResourceCollection resourceCollection) {
        this.resources.add(resourceCollection);
    }

    public List<String> getTestClassNames() {
        if (this.resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tests = new ArrayList<String>();
        for (Resource resource : this.resources) {
            String name;
            if (!resource.isExists() || !(name = resource.getName()).endsWith(".class")) continue;
            String className = name.substring(0, name.lastIndexOf(46));
            tests.add(className.replace(File.separatorChar, '.').replace('/', '.').replace('\\', '.'));
        }
        return tests;
    }

    @Override
    protected void toForkedRepresentation(JUnitLauncherTask task, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("test-classes");
        for (String test : this.getTestClassNames()) {
            writer.writeStartElement("test");
            writer.writeAttribute("classname", test);
            if (this.haltOnFailure != null) {
                writer.writeAttribute("haltOnFailure", this.haltOnFailure.toString());
            }
            if (this.outputDir != null) {
                writer.writeAttribute("outDir", this.outputDir);
            }
            if (this.includeEngines != null) {
                writer.writeAttribute("includeEngines", this.includeEngines);
            }
            if (this.excludeEngines != null) {
                writer.writeAttribute("excludeEngines", this.excludeEngines);
            }
            if (this.listeners != null) {
                for (ListenerDefinition listenerDef : this.getListeners()) {
                    if (!listenerDef.shouldUse(task.getProject())) continue;
                    listenerDef.toForkedRepresentation(writer);
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static List<TestDefinition> fromForkedRepresentation(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, "test-classes");
        TestClasses testDefinition = new TestClasses();
        while (reader.nextTag() != 2) {
            String excludeEngs;
            String includeEngs;
            String outDir;
            reader.require(1, null, "test");
            String testClassName = TestClasses.requireAttributeValue(reader, "classname");
            testDefinition.add((ResourceCollection)new StringResource(testClassName + ".class"));
            String halt = reader.getAttributeValue(null, "haltOnFailure");
            if (halt != null) {
                testDefinition.setHaltOnFailure(Boolean.parseBoolean(halt));
            }
            if ((outDir = reader.getAttributeValue(null, "outDir")) != null) {
                testDefinition.setOutputDir(outDir);
            }
            if ((includeEngs = reader.getAttributeValue(null, "includeEngines")) != null) {
                testDefinition.setIncludeEngines(includeEngs);
            }
            if ((excludeEngs = reader.getAttributeValue(null, "excludeEngines")) != null) {
                testDefinition.setExcludeEngines(excludeEngs);
            }
            while (reader.nextTag() != 2) {
                reader.require(1, null, "listener");
                testDefinition.addConfiguredListener(ListenerDefinition.fromForkedRepresentation(reader));
            }
            reader.require(2, null, "test");
        }
        reader.require(2, null, "test-classes");
        return Collections.singletonList(testDefinition);
    }

    private static String requireAttributeValue(XMLStreamReader reader, String attrName) throws XMLStreamException {
        String val = reader.getAttributeValue(null, attrName);
        if (val != null) {
            return val;
        }
        throw new XMLStreamException("Attribute " + attrName + " is missing at " + reader.getLocation());
    }
}

