# _JsonPrint
<span class="source-link">[[Source]](src/json/_json_print.md#L3)</span>
```pony
primitive val _JsonPrint
```

## Constructors

### create
<span class="source-link">[[Source]](src/json/_json_print.md#L3)</span>


```pony
new val create()
: _JsonPrint val^
```

#### Returns

* [_JsonPrint](json-_JsonPrint.md) val^

---

## Public Functions

### eq
<span class="source-link">[[Source]](src/json/_json_print.md#L4)</span>


```pony
fun box eq(
  that: _JsonPrint val)
: Bool val
```
#### Parameters

*   that: [_JsonPrint](json-_JsonPrint.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/json/_json_print.md#L4)</span>


```pony
fun box ne(
  that: _JsonPrint val)
: Bool val
```
#### Parameters

*   that: [_JsonPrint](json-_JsonPrint.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

## Private Functions

### _indent
<span class="source-link">[[Source]](src/json/_json_print.md#L4)</span>


Add indentation to the buf to the appropriate indent_level


```pony
fun box _indent(
  buf: String iso,
  indent: String val,
  level': USize val)
: String iso^
```
#### Parameters

*   buf: [String](builtin-String.md) iso
*   indent: [String](builtin-String.md) val
*   level': [USize](builtin-USize.md) val

#### Returns

* [String](builtin-String.md) iso^

---

### _string
<span class="source-link">[[Source]](src/json/_json_print.md#L19)</span>


Generate string representation of the given data.


```pony
fun box _string(
  d: (F64 val | I64 val | Bool val | 
    None val | String val | JsonArray box | 
    JsonObject box),
  buf': String iso,
  indent: String val,
  level: USize val,
  pretty: Bool val)
: String iso^
```
#### Parameters

*   d: ([F64](builtin-F64.md) val | [I64](builtin-I64.md) val | [Bool](builtin-Bool.md) val | 
    [None](builtin-None.md) val | [String](builtin-String.md) val | [JsonArray](json-JsonArray.md) box | 
    [JsonObject](json-JsonObject.md) box)
*   buf': [String](builtin-String.md) iso
*   indent: [String](builtin-String.md) val
*   level: [USize](builtin-USize.md) val
*   pretty: [Bool](builtin-Bool.md) val

#### Returns

* [String](builtin-String.md) iso^

---

### _escaped_string
<span class="source-link">[[Source]](src/json/_json_print.md#L87)</span>


Generate a version of the given string with escapes for all non-printable
and non-ASCII characters.


```pony
fun box _escaped_string(
  buf: String iso,
  s: String val)
: String iso^
```
#### Parameters

*   buf: [String](builtin-String.md) iso
*   s: [String](builtin-String.md) val

#### Returns

* [String](builtin-String.md) iso^

---

