/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.single;

import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.ui.commons.ClearModuleEvent;
import org.pdfsam.ui.selection.ToolbarButton;
import org.sejda.eventstudio.StaticStudio;

class SingleSelectionPaneToolbar
extends ToolBar
implements ModuleOwned {
    private String ownerModule = "";

    public SingleSelectionPaneToolbar(Button selectButton, String ownerModule) {
        this.ownerModule = StringUtils.defaultString((String)ownerModule);
        this.getItems().addAll((Object[])new Node[]{selectButton, new ClearButton(ownerModule)});
        this.getStyleClass().add((Object)"selection-tool-bar");
    }

    public String getOwnerModule() {
        return this.ownerModule;
    }

    static class ClearButton
    extends ToolbarButton {
        public ClearButton(String ownerModule) {
            super(ownerModule);
            this.setText(DefaultI18nContext.getInstance().i18n("_Clear"));
            this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Clear all settings")));
            this.setOnAction(this::clearAll);
            StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        }

        public void clearAll(ActionEvent event) {
            StaticStudio.eventStudio().broadcast((Object)new ClearModuleEvent(true), this.getOwnerModule());
        }
    }

    public static class SelectButton
    extends ToolbarButton {
        public SelectButton(String ownerModule) {
            super(ownerModule);
            this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Select the PDF file")));
            this.setText(DefaultI18nContext.getInstance().i18n("_Select PDF"));
        }
    }
}

