/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.notification;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import java.nio.file.AccessDeniedException;
import java.security.SecureRandom;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.pdfsam.ConfigurableProperty;
import org.pdfsam.Pdfsam;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.UsageService;
import org.pdfsam.news.NewImportantNewsEvent;
import org.pdfsam.ui.commons.UrlButton;
import org.pdfsam.ui.notification.AddNotificationRequestEvent;
import org.pdfsam.ui.notification.NotificationType;
import org.pdfsam.ui.notification.NotificationsContainer;
import org.pdfsam.ui.notification.RemoveNotificationRequestEvent;
import org.pdfsam.update.NoUpdateAvailable;
import org.pdfsam.update.UpdateAvailableEvent;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.injector.Auto;
import org.sejda.model.exception.InvalidTaskParametersException;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;

@Auto
public class NotificationsController {
    private static final int TIMES_BEFORE_ENTERPRISE_NOTICE = 5;
    private NotificationsContainer container;
    private UsageService service;
    private Pdfsam pdfsam;
    private UserContext userContext;
    private SecureRandom random = new SecureRandom();

    @Inject
    NotificationsController(NotificationsContainer container, UsageService service, Pdfsam pdfsam, UserContext userContext) {
        this.container = container;
        this.service = service;
        this.pdfsam = pdfsam;
        this.userContext = userContext;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onAddRequest(AddNotificationRequestEvent event) {
        this.container.addNotification(event.title, (Node)this.buildLabel(event.message, event.type));
    }

    private Label buildLabel(String message, NotificationType type) {
        Label textLabel = new Label(message);
        textLabel.getStyleClass().add((Object)"notification-text");
        if (type != null) {
            textLabel.getStyleClass().add((Object)type.getStyleClass());
            textLabel.setGraphic(type.getGraphic());
        }
        return textLabel;
    }

    @EventListener
    public void onTaskFailed(TaskExecutionFailedEvent e) {
        Throwable root;
        if (e.getFailingCause() instanceof InvalidTaskParametersException) {
            this.container.addNotification(DefaultI18nContext.getInstance().i18n("Invalid parameters"), (Node)this.buildLabel(DefaultI18nContext.getInstance().i18n("Input parameters are invalid, open the application messages for details."), NotificationType.ERROR));
        }
        if ((root = ExceptionUtils.getRootCause((Throwable)e.getFailingCause())) instanceof AccessDeniedException) {
            this.container.addNotification(DefaultI18nContext.getInstance().i18n("Access denied"), (Node)this.buildLabel(DefaultI18nContext.getInstance().i18n("Unable to access \"{0}\", please make sure you have write permissions or open the application messages for details.", ((AccessDeniedException)root).getFile()), NotificationType.ERROR));
        }
    }

    @EventListener
    public void onTaskCompleted(TaskExecutionCompletedEvent e) {
        long usages = this.service.getTotalUsage();
        if (usages % 5L == 0L && this.userContext.isDonationNotification()) {
            if (this.random.nextInt() % 2 == 0) {
                this.addDonationNotification(usages);
            } else {
                this.addShareNotification(usages);
            }
        }
    }

    private void addDonationNotification(long usages) {
        VBox content = new VBox(3.0, new Node[]{this.buildLabel(DefaultI18nContext.getInstance().i18n("You performed {0} tasks with PDFsam, did it help?", Long.toString(usages)), NotificationType.GO_PRO), UrlButton.styledUrlButton((String)DefaultI18nContext.getInstance().i18n("Give something back"), (String)this.pdfsam.property(ConfigurableProperty.DONATE_URL), null)});
        content.setAlignment(Pos.TOP_RIGHT);
        this.container.addStickyNotification(DefaultI18nContext.getInstance().i18n("PDFsam worked hard!"), (Node)content);
    }

    private void addShareNotification(long usages) {
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        VBox content = new VBox(3.0, new Node[]{this.buildLabel(DefaultI18nContext.getInstance().i18n("You performed {0} tasks with PDFsam, did it help?", Long.toString(usages)), NotificationType.SHARE), new HBox(3.0, new Node[]{spacer, UrlButton.styledUrlButton(null, (String)this.pdfsam.property(ConfigurableProperty.FACEBOOK_SHARE_URL), (FontAwesomeIcon)FontAwesomeIcon.FACEBOOK), UrlButton.styledUrlButton((String)DefaultI18nContext.getInstance().i18n("Spread the word!"), (String)this.pdfsam.property(ConfigurableProperty.TWEETER_SHARE_URL), (FontAwesomeIcon)FontAwesomeIcon.TWITTER)})});
        content.setAlignment(Pos.TOP_RIGHT);
        this.container.addStickyNotification(DefaultI18nContext.getInstance().i18n("PDFsam worked hard!"), (Node)content);
    }

    @EventListener
    public void onRemoveRequest(RemoveNotificationRequestEvent event) {
        this.container.removeNotification(event.notificationId);
    }

    @EventListener
    public void onUpdateAvailable(UpdateAvailableEvent event) {
        VBox content = new VBox(3.0, new Node[]{this.buildLabel(DefaultI18nContext.getInstance().i18n("PDFsam {0} is available for download", event.availableVersion), NotificationType.INFO), UrlButton.styledUrlButton((String)DefaultI18nContext.getInstance().i18n("Download"), (String)this.pdfsam.property(ConfigurableProperty.DOWNLOAD_URL), null)});
        content.setAlignment(Pos.TOP_RIGHT);
        this.container.addStickyNotification(DefaultI18nContext.getInstance().i18n("New version available"), (Node)content);
    }

    @EventListener
    public void onNoUpdateAvailable(NoUpdateAvailable event) {
        VBox content = new VBox(3.0, new Node[]{this.buildLabel(DefaultI18nContext.getInstance().i18n("You are running the latest version of PDFsam Basic"), NotificationType.INFO)});
        content.setAlignment(Pos.TOP_RIGHT);
        this.container.addNotification(DefaultI18nContext.getInstance().i18n("No update"), (Node)content);
    }

    @EventListener
    public void onNewImportantNews(NewImportantNewsEvent event) {
        VBox content = new VBox(3.0, new Node[]{this.buildLabel(event.news.getContent(), null), UrlButton.styledUrlButton((String)DefaultI18nContext.getInstance().i18n("Open"), (String)event.news.getLink(), (FontAwesomeIcon)FontAwesomeIcon.EXTERNAL_LINK)});
        content.setAlignment(Pos.TOP_RIGHT);
        this.container.addStickyNotification(event.news.getTitle(), (Node)content);
    }
}

