"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeTriggerActions = executeTriggerActions;

var _actions = require("../actions");

var _triggers = require("../triggers");

var _context_menu_actions = require("../context_menu_actions");

var _get_actions_for_trigger = require("../get_actions_for_trigger");

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function executeTriggerActions(_x, _x2) {
  return _executeTriggerActions.apply(this, arguments);
}

function _executeTriggerActions() {
  _executeTriggerActions = _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee(triggerId, _ref) {
    var embeddable, triggerContext, actions, closeMyContextMenuPanel, panel, session, href;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            embeddable = _ref.embeddable, triggerContext = _ref.triggerContext;
            _context.next = 3;
            return (0, _get_actions_for_trigger.getActionsForTrigger)(_actions.actionRegistry, _triggers.triggerRegistry, triggerId, {
              embeddable: embeddable
            });

          case 3:
            actions = _context.sent;

            if (!(actions.length > 1)) {
              _context.next = 12;
              break;
            }

            closeMyContextMenuPanel = function closeMyContextMenuPanel() {
              session.close();
            };

            _context.next = 8;
            return (0, _context_menu_actions.buildContextMenuForActions)({
              actions: actions,
              actionContext: triggerContext,
              closeMenu: closeMyContextMenuPanel
            });

          case 8:
            panel = _context.sent;
            session = (0, _context_menu_actions.openContextMenu)([panel]);
            _context.next = 13;
            break;

          case 12:
            if (actions.length === 1) {
              href = actions[0].getHref({
                embeddable: embeddable,
                triggerContext: triggerContext
              });

              if (href) {
                window.location.href = href;
              } else {
                actions[0].execute({
                  embeddable: embeddable,
                  triggerContext: triggerContext
                });
              }
            }

          case 13:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _executeTriggerActions.apply(this, arguments);
}