"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionsForTrigger = getActionsForTrigger;

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function getActionsForTrigger(_x, _x2, _x3, _x4) {
  return _getActionsForTrigger.apply(this, arguments);
}

function _getActionsForTrigger() {
  _getActionsForTrigger = _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee2(actionRegistry, triggerRegistry, triggerId, context) {
    var trigger, actions, promises;
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            trigger = triggerRegistry.get(triggerId);

            if (trigger) {
              _context2.next = 3;
              break;
            }

            throw new Error("Trigger with id ".concat(triggerId, " does not exist"));

          case 3:
            actions = [];
            promises = trigger.actionIds.map(
            /*#__PURE__*/
            function () {
              var _ref = _asyncToGenerator(
              /*#__PURE__*/
              regeneratorRuntime.mark(function _callee(id) {
                var action;
                return regeneratorRuntime.wrap(function _callee$(_context) {
                  while (1) {
                    switch (_context.prev = _context.next) {
                      case 0:
                        action = actionRegistry.get(id);

                        if (action) {
                          _context.next = 3;
                          break;
                        }

                        throw new Error("Action ".concat(id, " does not exist"));

                      case 3:
                        _context.next = 5;
                        return action.isCompatible(context);

                      case 5:
                        if (!_context.sent) {
                          _context.next = 7;
                          break;
                        }

                        actions.push(action);

                      case 7:
                      case "end":
                        return _context.stop();
                    }
                  }
                }, _callee);
              }));

              return function (_x5) {
                return _ref.apply(this, arguments);
              };
            }());
            _context2.next = 7;
            return Promise.all(promises);

          case 7:
            return _context2.abrupt("return", actions);

          case 8:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _getActionsForTrigger.apply(this, arguments);
}