/**
 * @since 1.0.0
 */
export const fieldNumber = {
    add: (x, y) => x + y,
    zero: 0,
    mul: (x, y) => x * y,
    one: 1,
    sub: (x, y) => x - y,
    degree: _ => 1,
    div: (x, y) => x / y,
    mod: (x, y) => x % y
};
/**
 * The *greatest common divisor* of two values
 *
 * @since 1.0.0
 */
export const gcd = (S, field) => {
    const zero = field.zero;
    const f = (x, y) => (S.equals(y, zero) ? x : f(y, field.mod(x, y)));
    return f;
};
/**
 * The *least common multiple* of two values
 *
 * @since 1.0.0
 */
export const lcm = (S, F) => {
    const zero = F.zero;
    const gcdSF = gcd(S, F);
    return (x, y) => (S.equals(x, zero) || S.equals(y, zero) ? zero : F.div(F.mul(x, y), gcdSF(x, y)));
};
