"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("../series/specs");
/**
 * Compute the chart dimensions. It's computed removing from the parent dimensions
 * the axis spaces, the legend and any other specified style margin and padding.
 * @param parentDimensions the parent dimension
 * @param chartTheme the theme style of the chart
 * @param axisDimensions the axis dimensions
 * @param axisSpecs the axis specs
 * @param showLegend is the legend shown
 * @param legendPosition the optional legend position
 */
function computeChartDimensions(parentDimensions, chartTheme, axisDimensions, axisSpecs, showLegend, legendPosition) {
    var chartMargins = chartTheme.chartMargins, chartPaddings = chartTheme.chartPaddings;
    var legendStyle = chartTheme.legend;
    var axisTitleStyle = chartTheme.axes.axisTitleStyle;
    var axisTitleHeight = axisTitleStyle.fontSize + axisTitleStyle.padding;
    var vLeftAxisSpecWidth = 0;
    var vRightAxisSpecWidth = 0;
    var hTopAxisSpecHeight = 0;
    var hBottomAxisSpecHeight = 0;
    axisDimensions.forEach(function (_a, id) {
        var _b = _a.maxLabelBboxWidth, maxLabelBboxWidth = _b === void 0 ? 0 : _b, _c = _a.maxLabelBboxHeight, maxLabelBboxHeight = _c === void 0 ? 0 : _c;
        var axisSpec = axisSpecs.get(id);
        if (!axisSpec || axisSpec.hide) {
            return;
        }
        var position = axisSpec.position, tickSize = axisSpec.tickSize, tickPadding = axisSpec.tickPadding, title = axisSpec.title;
        var titleHeight = title !== undefined ? axisTitleHeight : 0;
        switch (position) {
            case specs_1.Position.Top:
                hTopAxisSpecHeight += maxLabelBboxHeight + tickSize + tickPadding + chartMargins.top + titleHeight;
                break;
            case specs_1.Position.Bottom:
                hBottomAxisSpecHeight += maxLabelBboxHeight + tickSize + tickPadding + chartMargins.bottom + titleHeight;
                break;
            case specs_1.Position.Left:
                vLeftAxisSpecWidth += maxLabelBboxWidth + tickSize + tickPadding + chartMargins.left + titleHeight;
                break;
            case specs_1.Position.Right:
                vRightAxisSpecWidth += maxLabelBboxWidth + tickSize + tickPadding + chartMargins.right + titleHeight;
                break;
        }
    });
    // const hMargins = chartMargins.left + chartMargins.right;
    var chartWidth = parentDimensions.width - vLeftAxisSpecWidth - vRightAxisSpecWidth;
    var chartHeight = parentDimensions.height - hTopAxisSpecHeight - hBottomAxisSpecHeight;
    var vMargin = 0;
    if (hTopAxisSpecHeight === 0) {
        vMargin += chartMargins.top;
    }
    if (hBottomAxisSpecHeight === 0) {
        vMargin += chartMargins.bottom;
    }
    var hMargin = 0;
    if (vLeftAxisSpecWidth === 0) {
        hMargin += chartMargins.left;
    }
    if (vRightAxisSpecWidth === 0) {
        hMargin += chartMargins.right;
    }
    var legendTopMargin = 0;
    var legendLeftMargin = 0;
    if (showLegend) {
        switch (legendPosition) {
            case specs_1.Position.Right:
                hMargin += legendStyle.verticalWidth;
                break;
            case specs_1.Position.Left:
                hMargin += legendStyle.verticalWidth;
                legendLeftMargin = legendStyle.verticalWidth;
                break;
            case specs_1.Position.Top:
                vMargin += legendStyle.horizontalHeight;
                legendTopMargin = legendStyle.horizontalHeight;
                break;
            case specs_1.Position.Bottom:
                vMargin += legendStyle.horizontalHeight;
                break;
        }
    }
    var top = 0;
    var left = 0;
    if (hTopAxisSpecHeight === 0) {
        top = chartMargins.top + chartPaddings.top + legendTopMargin;
    }
    else {
        top = hTopAxisSpecHeight + chartPaddings.top + legendTopMargin;
    }
    if (vLeftAxisSpecWidth === 0) {
        left = chartMargins.left + chartPaddings.left + legendLeftMargin;
    }
    else {
        left = vLeftAxisSpecWidth + chartPaddings.left + legendLeftMargin;
    }
    return {
        top: top,
        left: left,
        width: chartWidth - hMargin - chartPaddings.left - chartPaddings.right,
        height: chartHeight - vMargin - chartPaddings.top - chartPaddings.bottom,
    };
}
exports.computeChartDimensions = computeChartDimensions;
//# sourceMappingURL=dimensions.js.map