"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var renderprops_konva_cjs_1 = require("react-spring/renderprops-konva.cjs");
var rendering_1 = require("../../lib/series/rendering");
var rendering_props_utils_1 = require("./utils/rendering_props_utils");
var LineGeometries = /** @class */ (function (_super) {
    __extends(LineGeometries, _super);
    function LineGeometries(props) {
        var _this = _super.call(this, props) || this;
        _this.barSeriesRef = react_1.default.createRef();
        _this.renderLinePoints = function (themeIsVisible) {
            var lines = _this.props.lines;
            return lines.reduce(function (acc, glyph, i) {
                var points = glyph.points, seriesPointStyle = glyph.seriesPointStyle;
                var isVisible = seriesPointStyle ? seriesPointStyle.visible : themeIsVisible;
                if (!isVisible) {
                    return acc;
                }
                var _a = _this.props.style.point, radius = _a.radius, strokeWidth = _a.strokeWidth, opacity = _a.opacity;
                var pointStyleProps = rendering_props_utils_1.buildPointStyleProps({
                    radius: radius,
                    strokeWidth: strokeWidth,
                    opacity: opacity,
                    seriesPointStyle: seriesPointStyle,
                });
                return __spread(acc, _this.renderPoints(points, i, pointStyleProps));
            }, []);
        };
        _this.renderPoints = function (linePoints, lineIndex, pointStyleProps) {
            var linePointsElements = [];
            linePoints.forEach(function (linePoint, pointIndex) {
                var x = linePoint.x, y = linePoint.y, color = linePoint.color, transform = linePoint.transform;
                if (_this.props.animated) {
                    linePointsElements.push(react_1.default.createElement(react_konva_1.Group, { key: "line-point-group-" + lineIndex + "-" + pointIndex, x: transform.x },
                        react_1.default.createElement(renderprops_konva_cjs_1.Spring, { native: true, from: { y: y }, to: { y: y } }, function () {
                            var pointProps = rendering_props_utils_1.buildLinePointProps({
                                lineIndex: lineIndex,
                                pointIndex: pointIndex,
                                x: x,
                                y: y,
                                color: color,
                                pointStyleProps: pointStyleProps,
                            });
                            return react_1.default.createElement(renderprops_konva_cjs_1.animated.Circle, __assign({}, pointProps));
                        })));
                }
                else {
                    var pointProps = rendering_props_utils_1.buildLinePointProps({
                        lineIndex: lineIndex,
                        pointIndex: pointIndex,
                        x: transform.x + x,
                        y: y,
                        color: color,
                        pointStyleProps: pointStyleProps,
                    });
                    linePointsElements.push(react_1.default.createElement(react_konva_1.Circle, __assign({}, pointProps)));
                }
            });
            return linePointsElements;
        };
        _this.renderLineGeoms = function (themeIsVisible) {
            var _a = _this.props, style = _a.style, lines = _a.lines, sharedStyle = _a.sharedStyle;
            var strokeWidth = style.line.strokeWidth;
            var lineElements = [];
            lines.forEach(function (glyph, index) {
                var line = glyph.line, color = glyph.color, transform = glyph.transform, geometryId = glyph.geometryId, seriesLineStyle = glyph.seriesLineStyle;
                var isVisible = seriesLineStyle ? seriesLineStyle.visible : themeIsVisible;
                if (!isVisible) {
                    return;
                }
                var customOpacity = seriesLineStyle ? seriesLineStyle.opacity : undefined;
                var geometryStyle = rendering_1.getGeometryStyle(geometryId, _this.props.highlightedLegendItem, sharedStyle, customOpacity);
                if (_this.props.animated) {
                    lineElements.push(react_1.default.createElement(react_konva_1.Group, { key: index, x: transform.x },
                        react_1.default.createElement(renderprops_konva_cjs_1.Spring, { native: true, reset: true, from: { opacity: 0 }, to: { opacity: 1 } }, function () {
                            var lineProps = rendering_props_utils_1.buildLineProps({
                                index: index,
                                xTransform: 0,
                                linePath: line,
                                color: color,
                                strokeWidth: strokeWidth,
                                geometryStyle: geometryStyle,
                                seriesLineStyle: seriesLineStyle,
                            });
                            return react_1.default.createElement(renderprops_konva_cjs_1.animated.Path, __assign({}, lineProps));
                        })));
                }
                else {
                    var lineProps = rendering_props_utils_1.buildLineProps({
                        index: index,
                        xTransform: transform.x,
                        linePath: line,
                        color: color,
                        strokeWidth: strokeWidth,
                        geometryStyle: geometryStyle,
                        seriesLineStyle: seriesLineStyle,
                    });
                    lineElements.push(react_1.default.createElement(react_konva_1.Path, __assign({}, lineProps)));
                }
            });
            return lineElements;
        };
        _this.barSeriesRef = react_1.default.createRef();
        _this.state = {
            overPoint: undefined,
        };
        return _this;
    }
    LineGeometries.prototype.render = function () {
        var _a = this.props.style, point = _a.point, line = _a.line;
        return (react_1.default.createElement(react_konva_1.Group, { ref: this.barSeriesRef, key: 'bar_series' },
            this.renderLineGeoms(line.visible),
            this.renderLinePoints(point.visible)));
    };
    LineGeometries.defaultProps = {
        animated: false,
    };
    return LineGeometries;
}(react_1.default.PureComponent));
exports.LineGeometries = LineGeometries;
//# sourceMappingURL=line_geometries.js.map