/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.Benchmark;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class BenchmarkThread
extends Thread {
    int ntrans = 0;
    Connection Conn;
    Benchmark bench;
    PreparedStatement pstmt1 = null;
    PreparedStatement pstmt2 = null;
    PreparedStatement pstmt3 = null;
    PreparedStatement pstmt4 = null;
    PreparedStatement pstmt5 = null;

    public BenchmarkThread(int n, String string, String string2, String string3, Benchmark benchmark) {
        this.bench = benchmark;
        this.ntrans = n;
        this.Conn = benchmark.connect(string, string2, string3);
        if (this.Conn == null) {
            return;
        }
        try {
            if (Benchmark.transactions) {
                this.Conn.setAutoCommit(false);
            }
            if (Benchmark.prepared_stmt) {
                String string4 = "UPDATE accounts";
                string4 = string4 + " SET Abalance = Abalance + ?";
                string4 = string4 + " WHERE Aid = ?";
                this.pstmt1 = this.Conn.prepareStatement(string4);
                string4 = "SELECT Abalance";
                string4 = string4 + " FROM accounts";
                string4 = string4 + " WHERE Aid = ?";
                this.pstmt2 = this.Conn.prepareStatement(string4);
                string4 = "UPDATE tellers";
                string4 = string4 + " SET Tbalance = Tbalance + ?";
                string4 = string4 + " WHERE  Tid = ?";
                this.pstmt3 = this.Conn.prepareStatement(string4);
                string4 = "UPDATE branches";
                string4 = string4 + " SET Bbalance = Bbalance + ?";
                string4 = string4 + " WHERE  Bid = ?";
                this.pstmt4 = this.Conn.prepareStatement(string4);
                string4 = "INSERT INTO history(Tid, Bid, Aid, delta)";
                string4 = string4 + " VALUES (?,?,?,?)";
                this.pstmt5 = this.Conn.prepareStatement(string4);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (this.ntrans-- > 0) {
            int n = Benchmark.getRandomID(2);
            int n2 = Benchmark.getRandomID(1);
            int n3 = Benchmark.getRandomID(0);
            int n4 = Benchmark.getRandomInt(0, 1000);
            this.doOne(n2, n3, n, n4);
            this.bench.incrementTransactionCount();
        }
        if (Benchmark.prepared_stmt) {
            try {
                if (this.pstmt1 != null) {
                    this.pstmt1.close();
                }
                if (this.pstmt2 != null) {
                    this.pstmt2.close();
                }
                if (this.pstmt3 != null) {
                    this.pstmt3.close();
                }
                if (this.pstmt4 != null) {
                    this.pstmt4.close();
                }
                if (this.pstmt5 != null) {
                    this.pstmt5.close();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
        Benchmark.connectClose(this.Conn);
        this.Conn = null;
    }

    int doOne(int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (this.Conn == null) {
            this.bench.incrementFailedTransactionCount();
            return 0;
        }
        try {
            if (Benchmark.prepared_stmt) {
                this.pstmt1.setInt(1, n4);
                this.pstmt1.setInt(2, n3);
                this.pstmt1.executeUpdate();
                this.pstmt1.clearWarnings();
                this.pstmt2.setInt(1, n3);
                ResultSet resultSet = this.pstmt2.executeQuery();
                this.pstmt2.clearWarnings();
                while (resultSet.next()) {
                    n5 = resultSet.getInt(1);
                }
                this.pstmt3.setInt(1, n4);
                this.pstmt3.setInt(2, n2);
                this.pstmt3.executeUpdate();
                this.pstmt3.clearWarnings();
                this.pstmt4.setInt(1, n4);
                this.pstmt4.setInt(2, n);
                this.pstmt4.executeUpdate();
                this.pstmt4.clearWarnings();
                this.pstmt5.setInt(1, n2);
                this.pstmt5.setInt(2, n);
                this.pstmt5.setInt(3, n3);
                this.pstmt5.setInt(4, n4);
                this.pstmt5.executeUpdate();
                this.pstmt5.clearWarnings();
            } else {
                Statement statement = this.Conn.createStatement();
                String string = "UPDATE accounts";
                string = string + " SET Abalance = Abalance + " + n4;
                string = string + " WHERE Aid = " + n3;
                statement.executeUpdate(string);
                statement.clearWarnings();
                string = "SELECT Abalance";
                string = string + " FROM accounts";
                string = string + " WHERE Aid = " + n3;
                ResultSet resultSet = statement.executeQuery(string);
                statement.clearWarnings();
                while (resultSet.next()) {
                    n5 = resultSet.getInt(1);
                }
                string = "UPDATE tellers";
                string = string + " SET Tbalance = Tbalance + " + n4;
                string = string + " WHERE Tid = " + n2;
                statement.executeUpdate(string);
                statement.clearWarnings();
                string = "UPDATE branches";
                string = string + " SET Bbalance = Bbalance + " + n4;
                string = string + " WHERE Bid = " + n;
                statement.executeUpdate(string);
                statement.clearWarnings();
                string = "INSERT INTO history(Tid, Bid, Aid, delta)";
                string = string + " VALUES (";
                string = string + n2 + ",";
                string = string + n + ",";
                string = string + n3 + ",";
                string = string + n4 + ")";
                statement.executeUpdate(string);
                statement.clearWarnings();
                statement.close();
            }
            if (Benchmark.transactions) {
                this.Conn.commit();
            }
            return n5;
        }
        catch (Exception exception) {
            if (Benchmark.verbose) {
                System.out.println("Transaction failed: " + exception.getMessage());
                exception.printStackTrace();
            }
            this.bench.incrementFailedTransactionCount();
            if (Benchmark.transactions) {
                try {
                    this.Conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return 0;
        }
    }
}

