/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import esmska.data.Config;
import esmska.utils.RuntimeUtils;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.lang.ObjectUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import org.pushingpixels.substance.api.skin.SkinInfo;

public class ThemeManager {
    private static final Logger logger = Logger.getLogger(ThemeManager.class.getName());
    private static UIManager.LookAndFeelInfo[] installedLafs = UIManager.getInstalledLookAndFeels();
    private static LAF activeLaf = LAF.CROSSPLATFORM;
    private static final String macBarUI = UIManager.getString("MenuBarUI");

    private ThemeManager() {
    }

    public static void setLaF() throws Throwable {
        Config config = Config.getInstance();
        LAF laf = config.getLookAndFeel();
        if (!ThemeManager.isLaFSupported(laf)) {
            LAF newLaf = ThemeManager.suggestBestLAF();
            logger.info("Look and feel '" + (Object)((Object)laf) + "' is no longer supported on your system, selected a new one: " + (Object)((Object)newLaf));
            laf = newLaf;
            config.setLookAndFeel(laf);
        }
        ThemeManager.setLaFDecorated(false);
        switch (laf) {
            case SYSTEM: {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                activeLaf = LAF.SYSTEM;
                break;
            }
            case CROSSPLATFORM: {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                activeLaf = LAF.CROSSPLATFORM;
                break;
            }
            case GTK: {
                boolean found = false;
                for (UIManager.LookAndFeelInfo lafInfo : installedLafs) {
                    if (!"GTK+".equals(lafInfo.getName())) continue;
                    UIManager.setLookAndFeel(lafInfo.getClassName());
                    found = true;
                    break;
                }
                if (!found) {
                    throw new IllegalStateException("GTK LaF requested, but not found");
                }
                activeLaf = LAF.GTK;
                break;
            }
            case JGOODIES: {
                String themeString = config.getLafJGoodiesTheme();
                PlasticTheme theme = null;
                for (Object o : PlasticLookAndFeel.getInstalledThemes()) {
                    PlasticTheme ptheme = (PlasticTheme)o;
                    if (!ptheme.getName().equals(themeString)) continue;
                    theme = ptheme;
                    break;
                }
                PlasticLookAndFeel.setPlasticTheme(theme != null ? theme : new ExperienceBlue());
                UIManager.setLookAndFeel(new PlasticXPLookAndFeel());
                activeLaf = LAF.JGOODIES;
                break;
            }
            case SUBSTANCE: {
                String skinString = config.getLafSubstanceSkin();
                String skin = null;
                for (SkinInfo skinInfo : SubstanceLookAndFeel.getAllSkins().values()) {
                    if (!skinInfo.getDisplayName().equals(skinString)) continue;
                    skin = skinInfo.getClassName();
                    break;
                }
                SubstanceLookAndFeel.setSkin(skin != null ? skin : new BusinessBlackSteelSkin().getClass().getName());
                UIManager.put("lafwidgets.textEditContextMenu", Boolean.TRUE);
                UIManager.put("substancelaf.addWidgets", Boolean.TRUE);
                ThemeManager.setLaFDecorated(true);
                activeLaf = LAF.SUBSTANCE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown LaF name");
            }
        }
        if (RuntimeUtils.isMac() && macBarUI != null) {
            logger.fine("Setting Mac OS MenuBar UI");
            UIManager.put("MenuBarUI", macBarUI);
        }
        logger.fine("New LaF set: " + UIManager.getLookAndFeel());
    }

    public static LAF getActiveLaF() {
        return activeLaf;
    }

    public static boolean isGTKCurrentLaF() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return ObjectUtils.equals(laf.getName(), "GTK look and feel");
    }

    public static boolean isAquaCurrentLaF() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return ObjectUtils.equals(laf.getName(), "Mac OS X");
    }

    public static boolean isNimbusCurrentLaF() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return ObjectUtils.equals(laf.getName(), "Nimbus");
    }

    public static boolean isSubstanceCurrentLaF() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return laf.getName() != null && laf.getName().startsWith("Substance");
    }

    public static boolean isCurrentSkinDark() {
        return ThemeManager.isSubstanceCurrentLaF() && SubstanceLookAndFeel.getCurrentSkin().getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).isDark();
    }

    public static boolean isLaFSupported(LAF laf) {
        switch (laf) {
            case SYSTEM: {
                return !UIManager.getSystemLookAndFeelClassName().equals(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            case CROSSPLATFORM: {
                return true;
            }
            case GTK: {
                for (UIManager.LookAndFeelInfo lafInfo : installedLafs) {
                    if (!"GTK+".equals(lafInfo.getName())) continue;
                    return !lafInfo.getClassName().equals(UIManager.getSystemLookAndFeelClassName());
                }
                return false;
            }
            case JGOODIES: {
                return true;
            }
            case SUBSTANCE: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown LAF: " + (Object)((Object)laf));
    }

    public static LAF suggestBestLAF() {
        LAF laf = LAF.SYSTEM;
        if (RuntimeUtils.isWindows() || RuntimeUtils.isOracleJava()) {
            laf = LAF.SUBSTANCE;
        }
        if (!ThemeManager.isLaFSupported(laf)) {
            laf = LAF.CROSSPLATFORM;
        }
        logger.finer("Suggested LaF: " + (Object)((Object)laf));
        return laf;
    }

    private static void setNimbusAsCrossplatformLAF() {
        for (UIManager.LookAndFeelInfo lafInfo : installedLafs) {
            if (!"Nimbus".equals(lafInfo.getName())) continue;
            System.setProperty("swing.crossplatformlaf", lafInfo.getClassName());
            return;
        }
    }

    private static void setLaFDecorated(boolean decorated) {
        JFrame.setDefaultLookAndFeelDecorated(decorated);
        JDialog.setDefaultLookAndFeelDecorated(decorated);
    }

    static {
        ThemeManager.setNimbusAsCrossplatformLAF();
    }

    public static enum LAF {
        SYSTEM,
        CROSSPLATFORM,
        GTK,
        JGOODIES,
        SUBSTANCE;

    }
}

