/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.filters;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.internal.ui.Logger;

public class NonPHPProjectsFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IProject) {
            return this.testProject((IProject)element);
        }
        if (element instanceof IScriptProject) {
            return this.testProject(((IScriptProject)element).getProject());
        }
        return true;
    }

    public boolean testProject(IProject project) {
        try {
            if (project != null && project.isAccessible() && !PHPToolkitUtil.isPHPProject((IProject)project)) {
                return false;
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return true;
    }
}

