/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class ScalablePolygonShape
extends AbstractPointListShape {
    private static final Rectangle TEMPLATEBOUNDS = Rectangle.SINGLETON;
    private PointList scaledPoints;

    protected boolean shapeContainsPoint(int x, int y) {
        Point location = this.getLocation();
        return Geometry.polygonContainsPoint(this.getScaledPoints(), x - location.x, y - location.y);
    }

    protected void fillShape(Graphics graphics) {
        graphics.pushState();
        graphics.translate(this.getLocation());
        graphics.fillPolygon(this.getScaledPoints());
        graphics.popState();
    }

    protected void outlineShape(Graphics graphics) {
        graphics.pushState();
        graphics.translate(this.getLocation());
        graphics.drawPolygon(this.getScaledPoints());
        graphics.popState();
    }

    private Rectangle getTemplateBounds() {
        TEMPLATEBOUNDS.setLocation(0, 0);
        TEMPLATEBOUNDS.setSize(0, 0);
        int[] intArray = this.points.toIntArray();
        int i = 0;
        while (i < intArray.length) {
            int y;
            int x;
            if ((x = intArray[i++]) > ScalablePolygonShape.TEMPLATEBOUNDS.width) {
                ScalablePolygonShape.TEMPLATEBOUNDS.width = x;
            }
            if ((y = intArray[i++]) <= ScalablePolygonShape.TEMPLATEBOUNDS.height) continue;
            ScalablePolygonShape.TEMPLATEBOUNDS.height = y;
        }
        return TEMPLATEBOUNDS;
    }

    public PointList getScaledPoints() {
        if (this.scaledPoints != null) {
            return this.scaledPoints;
        }
        Rectangle pointsBounds = this.getTemplateBounds();
        Rectangle actualBounds = this.getBounds();
        double xScale = actualBounds.width > this.lineWidth ? ((double)actualBounds.width - (double)this.lineWidth) / (double)pointsBounds.width : 0.0;
        double yScale = actualBounds.height > this.lineWidth ? ((double)actualBounds.height - (double)this.lineWidth) / (double)pointsBounds.height : 0.0;
        double halfLineWidth = (double)this.lineWidth / 2.0;
        int[] pointsArray = this.points.getCopy().toIntArray();
        int i = 0;
        while (i < pointsArray.length) {
            pointsArray[i] = (int)(Math.floor((double)pointsArray[i] * xScale) + halfLineWidth);
            pointsArray[i + 1] = (int)(Math.floor((double)pointsArray[i + 1] * yScale) + halfLineWidth);
            i += 2;
        }
        this.scaledPoints = new PointList(pointsArray);
        return this.scaledPoints;
    }

    public void addPoint(Point pt) {
        this.scaledPoints = null;
        super.addPoint(pt);
    }

    public void insertPoint(Point pt, int index) {
        this.scaledPoints = null;
        super.insertPoint(pt, index);
    }

    public void removeAllPoints() {
        this.scaledPoints = null;
        super.removeAllPoints();
    }

    public void removePoint(int index) {
        this.scaledPoints = null;
        super.removePoint(index);
    }

    public void setStart(Point start) {
        this.scaledPoints = null;
        super.setStart(start);
    }

    public void setEnd(Point end) {
        this.scaledPoints = null;
        super.setEnd(end);
    }

    public void setPoint(Point pt, int index) {
        this.scaledPoints = null;
        super.setPoint(pt, index);
    }

    public void setPoints(PointList points) {
        this.scaledPoints = null;
        super.setPoints(points);
    }

    public void setBounds(Rectangle rect) {
        this.scaledPoints = null;
        super.setBounds(rect);
    }

    public void setLineWidth(int w) {
        this.scaledPoints = null;
        super.setLineWidth(w);
    }
}

