/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.contextswitch;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

@NonNullByDefault
public class KernelContextSwitchStateProvider
extends AbstractTmfStateProvider {
    private static final String ID = "org.eclipse.tracecompass.analysis.os.linux.contextswitch.stateprovider";
    private static final int STARTING_QUARK = -1;
    private int fCpuAttributeQuark = -1;
    private @Nullable ITmfStateSystemBuilder fStateSystemBuilder;
    private IKernelAnalysisEventLayout fLayout;

    public KernelContextSwitchStateProvider(ITmfTrace trace, IKernelAnalysisEventLayout layout) {
        super(trace, ID);
        this.fLayout = layout;
    }

    public int getVersion() {
        return 1;
    }

    public ITmfStateProvider getNewInstance() {
        return new KernelContextSwitchStateProvider(this.getTrace(), this.fLayout);
    }

    protected void eventHandle(ITmfEvent event) {
        ITmfStateSystemBuilder stateSystemBuilder = this.fStateSystemBuilder;
        if (stateSystemBuilder == null) {
            this.fStateSystemBuilder = stateSystemBuilder = (ITmfStateSystemBuilder)this.getAssignedStateSystem();
        }
        if (stateSystemBuilder == null) {
            return;
        }
        if (this.fCpuAttributeQuark == -1) {
            this.fCpuAttributeQuark = stateSystemBuilder.getQuarkAbsoluteAndAdd(new String[]{"CPUs"});
        }
        if (event.getName().equals(this.fLayout.eventSchedSwitch())) {
            Object cpuObj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
            if (cpuObj == null) {
                return;
            }
            int cpuQuark = stateSystemBuilder.getQuarkRelativeAndAdd(this.fCpuAttributeQuark, new String[]{cpuObj.toString()});
            try {
                StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)stateSystemBuilder, (long)event.getTimestamp().getValue(), (int)cpuQuark, (int)1);
            }
            catch (AttributeNotFoundException | StateValueTypeException e) {
                Activator.getDefault().logError(NonNullUtils.nullToEmptyString((Object)e.getMessage()), e);
            }
        }
    }
}

