/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;

public class DBVColorOverride {
    private String attributeName;
    private boolean isRange;
    private boolean singleColumn;
    private DBCLogicalOperator operator;
    private Object[] attributeValues;
    private String colorForeground;
    private String colorForeground2;
    private String colorBackground;
    private String colorBackground2;

    public DBVColorOverride(String attributeName, DBCLogicalOperator operator, Object[] attributeValues, String colorForeground, String colorBackground) {
        this.attributeName = attributeName;
        this.operator = operator;
        this.attributeValues = attributeValues;
        this.colorForeground = colorForeground;
        this.colorBackground = colorBackground;
    }

    public DBVColorOverride(DBVColorOverride source) {
        this.attributeName = source.attributeName;
        this.operator = source.operator;
        this.attributeValues = source.attributeValues == null ? null : Arrays.copyOf(source.attributeValues, source.attributeValues.length);
        this.colorForeground = source.colorForeground;
        this.colorBackground = source.colorBackground;
        this.colorForeground2 = source.colorForeground2;
        this.colorBackground2 = source.colorBackground2;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public boolean isRange() {
        return this.isRange;
    }

    public void setRange(boolean range) {
        this.isRange = range;
    }

    public boolean isSingleColumn() {
        return this.singleColumn;
    }

    public void setSingleColumn(boolean singleColumn) {
        this.singleColumn = singleColumn;
    }

    public DBCLogicalOperator getOperator() {
        return this.operator;
    }

    public void setOperator(DBCLogicalOperator operator) {
        this.operator = operator;
    }

    public Object[] getAttributeValues() {
        return this.attributeValues;
    }

    public void setAttributeValues(Object[] attributeValues) {
        this.attributeValues = attributeValues;
    }

    public void addAttributeValue(Object value) {
        if (this.attributeValues == null) {
            this.attributeValues = new Object[]{value};
        } else {
            Object[] newValue = new Object[this.attributeValues.length + 1];
            System.arraycopy(this.attributeValues, 0, newValue, 0, this.attributeValues.length);
            newValue[newValue.length - 1] = value;
            this.attributeValues = newValue;
        }
    }

    public String getColorForeground() {
        return this.colorForeground;
    }

    public void setColorForeground(String colorForeground) {
        this.colorForeground = colorForeground;
    }

    public String getColorForeground2() {
        return this.colorForeground2;
    }

    public void setColorForeground2(String colorForeground2) {
        this.colorForeground2 = colorForeground2;
    }

    public String getColorBackground() {
        return this.colorBackground;
    }

    public void setColorBackground(String colorBackground) {
        this.colorBackground = colorBackground;
    }

    public String getColorBackground2() {
        return this.colorBackground2;
    }

    public void setColorBackground2(String colorBackground2) {
        this.colorBackground2 = colorBackground2;
    }

    public boolean matches(@NotNull String attrName, @NotNull DBCLogicalOperator operator, @Nullable Object[] values) {
        return attrName.equals(this.attributeName) && operator == this.operator && Arrays.equals(this.attributeValues, values);
    }

    public String toString() {
        return String.valueOf(this.attributeName) + " " + this.operator.toString() + " " + Arrays.toString(this.attributeValues);
    }
}

