/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractObjectCache;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class JDBCObjectCache<OWNER extends DBSObject, OBJECT extends DBSObject>
extends AbstractObjectCache<OWNER, OBJECT> {
    public static final int DEFAULT_MAX_CACHE_SIZE = 1000000;
    private static final Log log = Log.getLog(JDBCObjectCache.class);
    private int maximumCacheSize = 1000000;

    protected JDBCObjectCache() {
    }

    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    protected abstract JDBCStatement prepareObjectsStatement(@NotNull JDBCSession var1, @NotNull OWNER var2) throws SQLException;

    @Nullable
    protected abstract OBJECT fetchObject(@NotNull JDBCSession var1, @NotNull OWNER var2, @NotNull JDBCResultSet var3) throws SQLException, DBException;

    @Override
    @NotNull
    public Collection<OBJECT> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable OWNER owner) throws DBException {
        if (!this.isFullyCached()) {
            this.loadObjects(monitor, owner);
        }
        return this.getCachedObjects();
    }

    @Override
    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull String name) throws DBException {
        if (!this.isFullyCached()) {
            this.loadObjects(monitor, owner);
        }
        return this.getCachedObject(name);
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void loadObjects(DBRProgressMonitor monitor, OWNER owner) throws DBException {
        block31: {
            if (this.isFullyCached() || monitor.isCanceled()) {
                return;
            }
            tmpObjectList = new ArrayList<OBJECT>();
            dataSource = owner.getDataSource();
            if (dataSource == null) {
                throw new DBException(ModelMessages.error_not_connected_to_database);
            }
            try {
                try {
                    var5_5 = null;
                    var6_9 = null;
                    try {
                        session = (JDBCSession)DBUtils.openMetaSession(monitor, owner, "Load objects from " + owner.getName());
                        try {
                            var8_12 = null;
                            var9_14 = null;
                            try {
                                dbStat = this.prepareObjectsStatement(session, owner);
                                try {
                                    monitor.subTask("Load " + this.getCacheName());
                                    dbStat.setFetchSize(1000);
                                    dbStat.executeStatement();
                                    dbResult = dbStat.getResultSet();
                                    if (dbResult == null) break block31;
                                    if (!dbResult.next()) break block31;
                                    while (true) {
                                        if (session != null) {
                                            session.close();
                                        }
                                        return;
                                    }
                                    finally {
                                        dbResult.close();
                                    }
                                }
                                finally {
                                    if (dbStat == null) ** continue;
                                    dbStat.close();
                                }
                            }
                            catch (Throwable var9_15) {
                                if (var8_12 == null) {
                                    var8_12 = var9_15;
                                } else if (var8_12 != var9_15) {
                                    var8_12.addSuppressed(var9_15);
                                }
                                throw var8_12;
                            }
                        }
                        finally {
                            if (session != null) {
                                session.close();
                            }
                        }
                    }
                    catch (Throwable var6_10) {
                        if (var5_5 == null) {
                            var5_5 = var6_10;
                        } else if (var5_5 != var6_10) {
                            var5_5.addSuppressed(var6_10);
                        }
                        throw var5_5;
                    }
                }
                catch (SQLException ex) {
                    throw new DBException(ex, dataSource);
                }
            }
            catch (DBException e) {
                if (this.handleCacheReadError(e)) break block31;
                throw e;
            }
        }
        this.addCustomObjects(tmpObjectList);
        comparator = this.getListOrderComparator();
        if (comparator != null) {
            tmpObjectList.sort(comparator);
        }
        this.detectCaseSensitivity((DBSObject)owner);
        this.mergeCache(tmpObjectList);
        this.invalidateObjects(monitor, owner, new AbstractObjectCache.CacheIterator());
    }

    protected String getCacheName() {
        return this.getClass().getSimpleName();
    }

    protected boolean handleCacheReadError(DBException error) {
        return false;
    }
}

