/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.ERDActivator;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IActiveWorkbenchPart;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;

public class ERDEditorEmbedded
extends ERDEditorPart
implements IDatabaseEditor,
IActiveWorkbenchPart {
    private static final Log log = Log.getLog(ERDEditorEmbedded.class);
    private Composite parent;

    public IDatabaseEditorInput getEditorInput() {
        return (IDatabaseEditorInput)super.getEditorInput();
    }

    public void recreateEditorControl() {
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public void activatePart() {
        if (this.progressControl == null) {
            super.createPartControl(this.parent);
            this.parent.layout();
        }
        if (this.isLoaded()) {
            return;
        }
        this.loadDiagram(false);
    }

    public void deactivatePart() {
    }

    @Override
    public void createPartControl(Composite parent) {
        this.parent = parent;
    }

    public void setFocus() {
        if (this.progressControl != null) {
            super.setFocus();
        }
    }

    private DBSObject getRootObject() {
        DBSObject object = this.getEditorInput().getDatabaseObject();
        if (object == null) {
            return null;
        }
        if (object instanceof DBPDataSourceContainer && object.getDataSource() != null) {
            object = object.getDataSource();
        }
        return object;
    }

    @Override
    protected synchronized void loadDiagram(boolean refreshMetadata) {
        DBSObject object = this.getRootObject();
        if (object == null) {
            return;
        }
        if (this.diagramLoadingJob != null) {
            return;
        }
        this.diagramLoadingJob = LoadingJob.createService((ILoadService)new DatabaseLoadService<EntityDiagram>("Load diagram '" + object.getName() + "'", object.getDataSource()){

            public EntityDiagram evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    return ERDEditorEmbedded.this.loadFromDatabase(monitor);
                }
                catch (DBException e) {
                    log.error((Object)"Error loading ER diagram", (Throwable)e);
                    return null;
                }
            }
        }, this.progressControl.createLoadVisualizer());
        this.diagramLoadingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ERDEditorEmbedded.this.diagramLoadingJob = null;
            }
        });
        this.diagramLoadingJob.schedule();
    }

    public DBCExecutionContext getExecutionContext() {
        return this.getEditorInput().getExecutionContext();
    }

    private EntityDiagram loadFromDatabase(DBRProgressMonitor monitor) throws DBException {
        EntityDiagram diagram;
        DBSObject dbObject = this.getRootObject();
        if (dbObject == null) {
            log.error((Object)"Database object must be entity container to render ERD diagram");
            return null;
        }
        if (!dbObject.isPersisted()) {
            diagram = new EntityDiagram(this.getDecorator(), dbObject, "New Object");
        } else {
            diagram = new EntityDiagram(this.getDecorator(), dbObject, dbObject.getName());
            diagram.fillEntities(monitor, this.collectDatabaseTables(monitor, dbObject), dbObject);
        }
        return diagram;
    }

    private Collection<DBSEntity> collectDatabaseTables(DBRProgressMonitor monitor, DBSObject root) throws DBException {
        LinkedHashSet<DBSEntity> result = new LinkedHashSet<DBSEntity>();
        if (root instanceof DBSObjectContainer) {
            monitor.beginTask("Load '" + root.getName() + "' content", 3);
            DBSObjectContainer objectContainer = (DBSObjectContainer)root;
            try {
                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)objectContainer.getDataSource(), param -> {
                    try {
                        objectContainer.cacheStructure(monitor, 7);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Cache database model", "Error caching database model", (Throwable)e);
            }
            boolean showViews = ERDActivator.getDefault().getPreferenceStore().getBoolean("erd.diagram.show.views");
            Collection entities = objectContainer.getChildren(monitor);
            if (entities != null) {
                Class childType = objectContainer.getChildType(monitor);
                DBSObjectFilter objectFilter = objectContainer.getDataSource().getContainer().getObjectFilter(childType, (DBSObject)objectContainer, true);
                for (DBSObject entity : entities) {
                    DBSEntity entity1;
                    if (!(entity instanceof DBSEntity) || objectFilter != null && objectFilter.isEnabled() && !objectFilter.matches(entity.getName()) || (entity1 = (DBSEntity)entity).getEntityType() != DBSEntityType.TABLE && entity1.getEntityType() != DBSEntityType.CLASS && entity1.getEntityType() != DBSEntityType.VIRTUAL_ENTITY && (!showViews || entity1.getEntityType() != DBSEntityType.VIEW)) continue;
                    result.add(entity1);
                }
            }
            monitor.done();
        } else if (root instanceof DBSEntity) {
            monitor.beginTask("Load '" + root.getName() + "' relations", 3);
            DBSEntity rootTable = (DBSEntity)root;
            result.add(rootTable);
            try {
                monitor.subTask("Read foreign keys");
                List fks = DBVUtils.getAllAssociations((DBRProgressMonitor)monitor, (DBSEntity)rootTable);
                if (fks != null) {
                    for (DBSEntityAssociation fk : fks) {
                        DBSEntity associatedEntity = fk.getAssociatedEntity();
                        if (associatedEntity == null) continue;
                        result.add(associatedEntity);
                    }
                }
                monitor.worked(1);
            }
            catch (DBException e) {
                log.warn((Object)"Can't load table foreign keys", (Throwable)e);
            }
            if (monitor.isCanceled()) {
                return result;
            }
            try {
                monitor.subTask("Read references");
                List refs = DBVUtils.getAllReferences((DBRProgressMonitor)monitor, (DBSEntity)rootTable);
                if (refs != null) {
                    for (DBSEntityAssociation ref : refs) {
                        result.add(ref.getParentObject());
                    }
                }
                monitor.worked(1);
            }
            catch (DBException e) {
                log.warn((Object)"Can't load table references", (Throwable)e);
            }
            if (monitor.isCanceled()) {
                return result;
            }
            try {
                monitor.subTask("Read associations");
                ArrayList<DBSEntity> secondLevelEntities = new ArrayList<DBSEntity>();
                for (DBSEntity entity : result) {
                    Collection fks;
                    if (entity == rootTable || entity.getEntityType() != DBSEntityType.ASSOCIATION || (fks = entity.getAssociations(monitor)) == null) continue;
                    for (DBSEntityAssociation association : fks) {
                        if (association.getConstraintType() == DBSEntityConstraintType.INHERITANCE) continue;
                        secondLevelEntities.add(association.getAssociatedEntity());
                    }
                }
                result.addAll(secondLevelEntities);
                monitor.worked(1);
            }
            catch (DBException e) {
                log.warn((Object)"Can't load table references", (Throwable)e);
            }
            monitor.done();
        }
        return result;
    }
}

