/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraint;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.utils.CommonUtils;

public class GenericPrimaryKey
extends GenericTableConstraint {
    private List<GenericTableConstraintColumn> columns;

    public GenericPrimaryKey(GenericTableBase table, String name, @Nullable String remarks, DBSEntityConstraintType constraintType, boolean persisted) {
        super(table, name, remarks, constraintType, persisted);
    }

    GenericPrimaryKey(GenericPrimaryKey constraint) {
        super((GenericTableBase)constraint.getTable(), constraint.getName(), constraint.getDescription(), constraint.getConstraintType(), constraint.isPersisted());
        if (constraint.columns != null) {
            this.columns = new ArrayList<GenericTableConstraintColumn>(constraint.columns.size());
            for (GenericTableConstraintColumn sourceColumn : constraint.columns) {
                this.columns.add(new GenericTableConstraintColumn(this, sourceColumn));
            }
        }
    }

    public List<GenericTableConstraintColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        return this.columns;
    }

    public void addColumn(GenericTableConstraintColumn column) {
        if (this.columns == null) {
            this.columns = new ArrayList<GenericTableConstraintColumn>();
        }
        this.columns.add(column);
    }

    void setColumns(List<GenericTableConstraintColumn> columns) {
        this.columns = columns;
        if (!CommonUtils.isEmpty(this.columns) && this.columns.size() > 1) {
            Collections.sort(columns, new Comparator<GenericTableConstraintColumn>(){

                @Override
                public int compare(GenericTableConstraintColumn o1, GenericTableConstraintColumn o2) {
                    return o1.getOrdinalPosition() - o2.getOrdinalPosition();
                }
            });
        }
    }

    public boolean hasColumn(GenericTableColumn column) {
        if (this.columns != null) {
            for (GenericTableConstraintColumn constColumn : this.columns) {
                if (constColumn.getAttribute() != column) continue;
                return true;
            }
        }
        return false;
    }
}

