/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKeyColumn;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;

public class PostgreForeignKeyConfigurator
implements DBEObjectConfigurator<PostgreTableForeignKey> {
    public PostgreTableForeignKey configureObject(DBRProgressMonitor monitor, Object table, final PostgreTableForeignKey foreignKey) {
        return (PostgreTableForeignKey)new UITask<PostgreTableForeignKey>(){

            protected PostgreTableForeignKey runTask() {
                EditPGForeignKeyPage editPage = new EditPGForeignKeyPage(PostgreMessages.postgre_foreign_key_manager_header_edit_foreign_key, (DBSTableForeignKey)foreignKey);
                if (!editPage.edit()) {
                    return null;
                }
                foreignKey.setReferencedConstraint(editPage.getUniqueConstraint());
                foreignKey.setDeleteRule(editPage.getOnDeleteRule());
                foreignKey.setUpdateRule(editPage.getOnUpdateRule());
                int colIndex = 1;
                for (EditForeignKeyPage.FKColumnInfo tableColumn : editPage.getColumns()) {
                    foreignKey.addColumn(new PostgreTableForeignKeyColumn(foreignKey, (PostgreAttribute)((PostgreTableColumn)tableColumn.getOwnColumn()), colIndex++, (PostgreAttribute)((PostgreTableColumn)tableColumn.getRefColumn())));
                }
                foreignKey.setDeferrable(editPage.isDeferrable);
                foreignKey.setDeferred(editPage.isDeferred);
                return foreignKey;
            }
        }.execute();
    }

    private static class EditPGForeignKeyPage
    extends EditForeignKeyPage {
        private boolean isDeferrable;
        private boolean isDeferred;

        public EditPGForeignKeyPage(String title, DBSTableForeignKey foreignKey) {
            super(title, (DBSEntityAssociation)foreignKey, new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.CASCADE, DBSForeignKeyModifyRule.RESTRICT, DBSForeignKeyModifyRule.SET_NULL, DBSForeignKeyModifyRule.SET_DEFAULT});
        }

        protected Composite createPageContents(Composite parent) {
            Composite panel = super.createPageContents(parent);
            Composite defGroup = UIUtils.createComposite((Composite)panel, (int)2);
            defGroup.setLayoutData((Object)new GridData(768));
            final Button deferrableCheck = UIUtils.createCheckbox((Composite)defGroup, (String)PostgreMessages.postgre_foreign_key_manager_checkbox_deferrable, (boolean)false);
            deferrableCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    isDeferrable = deferrableCheck.getSelection();
                }
            });
            final Button deferredCheck = UIUtils.createCheckbox((Composite)defGroup, (String)PostgreMessages.postgre_foreign_key_manager_checkbox_deferred, (boolean)false);
            deferredCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    isDeferred = deferredCheck.getSelection();
                }
            });
            return panel;
        }
    }
}

