/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.hooks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.eclipse.jgit.api.errors.AbortedByHookException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.ProcessResult;

abstract class GitHook<T>
implements Callable<T> {
    private final Repository repo;
    protected final PrintStream outputStream;

    protected GitHook(Repository repo, PrintStream outputStream) {
        this.repo = repo;
        this.outputStream = outputStream;
    }

    @Override
    public abstract T call() throws IOException, AbortedByHookException;

    public abstract String getHookName();

    protected Repository getRepository() {
        return this.repo;
    }

    protected String[] getParameters() {
        return new String[0];
    }

    protected String getStdinArgs() {
        return null;
    }

    protected PrintStream getOutputStream() {
        return this.outputStream == null ? System.out : this.outputStream;
    }

    protected void doRun() throws AbortedByHookException {
        ByteArrayOutputStream errorByteArray = new ByteArrayOutputStream();
        PrintStream hookErrRedirect = null;
        try {
            hookErrRedirect = new PrintStream((OutputStream)errorByteArray, false, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ProcessResult result = FS.DETECTED.runHookIfPresent(this.getRepository(), this.getHookName(), this.getParameters(), this.getOutputStream(), hookErrRedirect, this.getStdinArgs());
        if (result.isExecutedWithError()) {
            throw new AbortedByHookException(new String(errorByteArray.toByteArray(), StandardCharsets.UTF_8), this.getHookName(), result.getExitCode());
        }
    }
}

